/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.block_entity;

import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.api.block_entity.SpecialFlowerBlockEntity;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.render.block_entity.FloatingFlowerBlockEntityRenderer;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.item.WandOfTheForestItem;
import vazkii.botania.common.item.equipment.bauble.ManaseerMonocleItem;

public class SpecialFlowerBlockEntityRenderer<T extends SpecialFlowerBlockEntity>
implements class_827<T> {
    public static final int INNER_ALPHA = 32;
    public static final int OUTER_ALPHA = 64;
    public static final float FRAME_WIDTH = 0.0625f;
    public static final float Y_OFFSET_INNER = 0.0625f;
    public static final float Y_OFFSET_OUTER = 0.078125f;
    public static final int TOTAL_ANGLES = 360;
    public static final double DEGREES_TO_RADIAN = Math.PI / 180;

    public SpecialFlowerBlockEntityRenderer(class_5614.class_5615 ctx) {
    }

    public void render(SpecialFlowerBlockEntity tile, float partialTicks, class_4587 ms, class_4597 buffers, int light, int overlay) {
        boolean hasBindingAttempt;
        class_1297 class_12972;
        if (tile.isFloating()) {
            FloatingFlowerBlockEntityRenderer.renderFloatingIsland(tile, partialTicks, ms, buffers, overlay);
        }
        if (!((class_12972 = class_310.method_1551().field_1719) instanceof class_1309)) {
            return;
        }
        class_1309 view = (class_1309)class_12972;
        if (!ManaseerMonocleItem.hasMonocle(view)) {
            return;
        }
        class_2338 pos = null;
        class_239 ray = class_310.method_1551().field_1765;
        if (ray != null && ray.method_17783() == class_239.class_240.field_1332) {
            pos = ((class_3965)ray).method_17777();
        }
        if ((hasBindingAttempt = SpecialFlowerBlockEntityRenderer.hasBindingAttempt(view, tile.method_11016())) || tile.method_11016().equals((Object)pos)) {
            SpecialFlowerBlockEntity flower = tile;
            ms.method_22903();
            if (hasBindingAttempt) {
                ms.method_22904(0.0, 0.005, 0.0);
            }
            SpecialFlowerBlockEntityRenderer.renderRadius(tile, ms, buffers, flower.getRadius());
            ms.method_22904(0.0, 0.002, 0.0);
            SpecialFlowerBlockEntityRenderer.renderRadius(tile, ms, buffers, flower.getSecondaryRadius());
            ms.method_22909();
        }
    }

    public static void renderRadius(class_2586 tile, class_4587 ms, class_4597 buffers, @Nullable RadiusDescriptor descriptor) {
        if (descriptor != null) {
            ms.method_22903();
            ms.method_22904(0.0, RenderHelper.getOffY(), 0.0);
            if (descriptor instanceof RadiusDescriptor.Circle) {
                RadiusDescriptor.Circle circle = (RadiusDescriptor.Circle)descriptor;
                SpecialFlowerBlockEntityRenderer.renderCircle(ms, buffers, tile.method_11016(), circle.subtileCoords(), circle.radius());
            } else if (descriptor instanceof RadiusDescriptor.Rectangle) {
                RadiusDescriptor.Rectangle rectangle = (RadiusDescriptor.Rectangle)descriptor;
                SpecialFlowerBlockEntityRenderer.renderRectangle(ms, buffers, tile.method_11016(), rectangle.aabb());
            }
            RenderHelper.incrementOffY();
            ms.method_22909();
        }
    }

    public static boolean hasBindingAttempt(class_1309 view, class_2338 tilePos) {
        class_1799 stackHeld = PlayerHelper.getFirstHeldItemClass(view, WandOfTheForestItem.class);
        if (!stackHeld.method_7960() && WandOfTheForestItem.getBindMode(stackHeld)) {
            return WandOfTheForestItem.getBindingAttempt(stackHeld).filter(arg_0 -> ((class_2338)tilePos).equals(arg_0)).isPresent();
        }
        return false;
    }

    public static void renderCircle(class_4587 ms, class_4597 buffers, class_2338 tilePos, class_2338 center, double radius) {
        ms.method_22903();
        ms.method_22904((double)(center.method_10263() - tilePos.method_10263()) + 0.5, (double)(center.method_10264() - tilePos.method_10264()), (double)(center.method_10260() - tilePos.method_10260()) + 0.5);
        int color = class_3532.method_15369((float)((float)(ClientTickHandler.ticksInGame % 200) / 200.0f), (float)0.6f, (float)1.0f);
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        class_4588 buffer = buffers.getBuffer(RenderHelper.CIRCLE);
        Matrix4f mat = ms.method_23760().method_23761();
        double innerRadius = radius - 0.0625;
        Runnable centerFuncInner = () -> buffer.method_22918(mat, 0.0f, 0.0625f, 0.0f).method_1336(r, g, b, 32).method_1344();
        Runnable centerFuncOuter = () -> buffer.method_22918(mat, 0.0f, 0.078125f, 0.0f).method_1336(r, g, b, 64).method_1344();
        Runnable[] vertexFuncsInner = new Runnable[361];
        Runnable[] vertexFuncsOuter = new Runnable[361];
        for (int i = 0; i < 360; ++i) {
            double rad = (double)(360 - i) * (Math.PI / 180);
            double cos = Math.cos(rad);
            double sin = Math.sin(rad);
            float xpInner = (float)(cos * innerRadius);
            float zpInner = (float)(sin * innerRadius);
            vertexFuncsInner[i] = () -> buffer.method_22918(mat, xpInner, 0.0625f, zpInner).method_1336(r, g, b, 32).method_1344();
            float xpOuter = (float)(Math.cos(rad) * radius);
            float zpOuter = (float)(Math.sin(rad) * radius);
            vertexFuncsOuter[i] = () -> buffer.method_22918(mat, xpOuter, 0.078125f, zpOuter).method_1336(r, g, b, 64).method_1344();
        }
        vertexFuncsInner[360] = vertexFuncsInner[0];
        vertexFuncsOuter[360] = vertexFuncsOuter[0];
        RenderHelper.triangleFan(centerFuncInner, vertexFuncsInner);
        RenderHelper.triangleFan(centerFuncOuter, vertexFuncsOuter);
        ms.method_22909();
    }

    public static void renderRectangle(class_4587 ms, class_4597 buffers, class_2338 tilePos, class_238 aabb) {
        ms.method_22903();
        ms.method_22904(aabb.field_1323 - (double)tilePos.method_10263(), aabb.field_1322 - (double)tilePos.method_10264(), aabb.field_1321 - (double)tilePos.method_10260());
        int color = class_3532.method_15369((float)((float)(ClientTickHandler.ticksInGame % 200) / 200.0f), (float)0.6f, (float)1.0f);
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        float xSize = (float)aabb.method_17939();
        float zSize = (float)aabb.method_17941();
        float xSizeInner = xSize - 0.0625f;
        float zSizeInner = zSize - 0.0625f;
        class_4588 buffer = buffers.getBuffer(RenderHelper.RECTANGLE);
        Matrix4f mat = ms.method_23760().method_23761();
        RenderHelper.flatRectangle(buffer, mat, 0.0625f, xSizeInner, 0.0625f, 0.0625f, zSizeInner, r, g, b, 32);
        RenderHelper.flatRectangle(buffer, mat, 0.0f, xSize, 0.078125f, 0.0f, zSize, r, g, b, 64);
        ms.method_22909();
    }
}

