/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.fabric.mixin;

import net.minecraft.class_1661;
import net.minecraft.class_1706;
import net.minecraft.class_1799;
import net.minecraft.class_3914;
import net.minecraft.class_3915;
import net.minecraft.class_3917;
import net.minecraft.class_4861;
import net.minecraft.world.inventory.*;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import vazkii.botania.common.item.SpellbindingClothItem;

@Mixin(class_1706.class)
public abstract class AnvilMenuFabricMixin extends class_4861 {
	@Shadow
	@Final
	private class_3915 cost;

	public AnvilMenuFabricMixin(class_3917<?> type, int i, class_1661 inv, class_3914 cla) {
		super(type, i, inv, cla);
	}

	@Inject(method = "createResult", at = @At("HEAD"), cancellable = true)
	private void checkIfCloth(CallbackInfo ci) {
		if (SpellbindingClothItem.shouldDenyAnvil(field_22480.method_5438(0), field_22480.method_5438(1))) {
			this.field_22479.method_5447(0, class_1799.field_8037);
			this.cost.method_17404(0);
			ci.cancel();
		}
	}
}
