/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.render;

import vazkii.botania.api.brew.Brew;
import vazkii.botania.api.brew.BrewItem;
import vazkii.botania.api.mana.BurstProperties;
import vazkii.botania.api.mana.ManaItem;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.PlatformBlock;
import vazkii.botania.common.block.block_entity.PlatformBlockEntity;
import vazkii.botania.common.block.block_entity.mana.ManaPoolBlockEntity;
import vazkii.botania.common.block.decor.PetalBlock;
import vazkii.botania.common.block.mana.ManaPoolBlock;
import vazkii.botania.common.brew.BotaniaBrews;
import vazkii.botania.common.item.*;
import vazkii.botania.common.item.equipment.bauble.TaintedBloodPendantItem;
import vazkii.botania.common.item.equipment.tool.terrasteel.TerraShattererItem;
import vazkii.botania.common.item.lens.LensItem;
import vazkii.botania.common.item.material.MysticalPetalItem;
import vazkii.botania.mixin.client.MinecraftAccessor;
import vazkii.botania.xplat.XplatAbstractions;

import java.util.Optional;
import net.minecraft.class_1163;
import net.minecraft.class_1268;
import net.minecraft.class_156;
import net.minecraft.class_1747;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1926;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_322;
import net.minecraft.class_326;
import net.minecraft.class_3532;

public final class ColorHandler {
	public interface BlockHandlerConsumer {
		void register(class_322 handler, class_2248... blocks);
	}

	public interface ItemHandlerConsumer {
		void register(class_326 handler, class_1935... items);
	}

	public static void submitBlocks(BlockHandlerConsumer blocks) {
		// [VanillaCopy] BlockColors for vine
		class_322 vineColor = (state, world, pos, tint) -> world != null && pos != null ? class_1163.method_4966(world, pos) : class_1926.method_8341();
		blocks.register(vineColor, BotaniaBlocks.solidVines);

		// Pool
		blocks.register(
				(state, world, pos, tintIndex) -> {
					if (tintIndex != 0) {
						return -1;
					}

					Optional<Integer> color = Optional.empty();
					if (world != null && pos != null) {
						class_2586 te = world.method_8321(pos);
						if (te instanceof ManaPoolBlockEntity pool) {
							color = pool.getColor().map(MysticalPetalItem::getPetalLikeColor);
						}
					}
					if (((ManaPoolBlock) state.method_26204()).variant == ManaPoolBlock.Variant.FABULOUS) {
						float time = (ClientTickHandler.ticksInGame + ClientTickHandler.partialTicks) * 0.005F;
						int fabulousColor = class_3532.method_15369(time - (int) time, 0.6F, 1F);
						return color.isEmpty() ? fabulousColor : vazkii.botania.common.helper.MathHelper.multiplyColor(fabulousColor, color.get());
					}
					return color.orElse(-1);
				},
				BotaniaBlocks.manaPool, BotaniaBlocks.creativePool, BotaniaBlocks.dilutedPool, BotaniaBlocks.fabulousPool
		);

		// Spreader
		blocks.register(
				(state, world, pos, tintIndex) -> {
					float time = ClientTickHandler.ticksInGame + ClientTickHandler.partialTicks;
					return class_3532.method_15369(time * 5 % 360 / 360F, 0.4F, 0.9F);
				},
				BotaniaBlocks.gaiaSpreader
		);

		// Petal Block
		blocks.register((state, world, pos, tintIndex) -> tintIndex == 0 ? MysticalPetalItem.getPetalLikeColor(((PetalBlock) state.method_26204()).color) : -1,
				BotaniaBlocks.petalBlockWhite, BotaniaBlocks.petalBlockOrange, BotaniaBlocks.petalBlockMagenta, BotaniaBlocks.petalBlockLightBlue,
				BotaniaBlocks.petalBlockYellow, BotaniaBlocks.petalBlockLime, BotaniaBlocks.petalBlockPink, BotaniaBlocks.petalBlockGray,
				BotaniaBlocks.petalBlockSilver, BotaniaBlocks.petalBlockCyan, BotaniaBlocks.petalBlockPurple, BotaniaBlocks.petalBlockBlue,
				BotaniaBlocks.petalBlockBrown, BotaniaBlocks.petalBlockGreen, BotaniaBlocks.petalBlockRed, BotaniaBlocks.petalBlockBlack
		);

		// Platforms
		blocks.register(
				(state, world, pos, tintIndex) -> {
					if (world != null && pos != null) {
						class_2586 tile = world.method_8321(pos);
						if (tile instanceof PlatformBlockEntity camo) {
							class_2680 camoState = camo.getCamoState();
							if (camoState != null) {
								return camoState.method_26204() instanceof PlatformBlock
										? 0xFFFFFF
										: class_310.method_1551().method_1505().method_1697(camoState, world, pos, tintIndex);
							}
						}
					}
					return 0xFFFFFF;
				}, BotaniaBlocks.abstrusePlatform, BotaniaBlocks.spectralPlatform, BotaniaBlocks.infrangiblePlatform);
	}

	public static void submitItems(ItemHandlerConsumer items) {
		items.register((s, t) -> t == 0 ? class_3532.method_15369(ClientTickHandler.ticksInGame * 2 % 360 / 360F, 0.25F, 1F) : -1,
				BotaniaItems.lifeEssence, BotaniaItems.gaiaIngot);

		items.register((s, t) -> t == 1 ? MysticalPetalItem.getPetalLikeColor(class_1767.method_7791(WandOfTheForestItem.getColor1(s)))
				: t == 2 ? MysticalPetalItem.getPetalLikeColor(class_1767.method_7791(WandOfTheForestItem.getColor2(s)))
				: -1,
				BotaniaItems.twigWand, BotaniaItems.dreamwoodWand);

		items.register((s, t) -> t == 0 ? class_310.method_1551().method_1505().method_1697(((class_1747) s.method_7909()).method_7711().method_9564(), null, null, t) : -1,
				BotaniaBlocks.petalBlockWhite, BotaniaBlocks.petalBlockOrange, BotaniaBlocks.petalBlockMagenta, BotaniaBlocks.petalBlockLightBlue,
				BotaniaBlocks.petalBlockYellow, BotaniaBlocks.petalBlockLime, BotaniaBlocks.petalBlockPink, BotaniaBlocks.petalBlockGray,
				BotaniaBlocks.petalBlockSilver, BotaniaBlocks.petalBlockCyan, BotaniaBlocks.petalBlockPurple, BotaniaBlocks.petalBlockBlue,
				BotaniaBlocks.petalBlockBrown, BotaniaBlocks.petalBlockGreen, BotaniaBlocks.petalBlockRed, BotaniaBlocks.petalBlockBlack,
				BotaniaBlocks.manaPool, BotaniaBlocks.creativePool, BotaniaBlocks.dilutedPool, BotaniaBlocks.fabulousPool, BotaniaBlocks.gaiaSpreader);

		items.register((s, t) -> {
			if (t == 1) {
				var manaItem = XplatAbstractions.INSTANCE.findManaItem(s);
				return class_3532.method_15369(0.528F, (float) manaItem.getMana() / (float) manaItem.getMaxMana(), 1F);
			}
			return -1;
		}, BotaniaItems.manaMirror);

		items.register((s, t) -> {
			if (t == 1) {
				var manaItem = XplatAbstractions.INSTANCE.findManaItem(s);
				return class_3532.method_15369(0.528F, (float) manaItem.getMana() / (float) manaItem.getMaxMana(), 1F);
			}
			return -1;
		}, BotaniaItems.manaTablet);

		items.register((s, t) -> t == 0 ? class_3532.method_15369(0.55F, ((float) s.method_7936() - (float) s.method_7919()) / (float) s.method_7936() * 0.5F, 1F) : -1, BotaniaItems.spellCloth);

		items.register((s, t) -> {
			if (t != 1) {
				return -1;
			}

			Brew brew = ((BrewItem) s.method_7909()).getBrew(s);
			if (brew == BotaniaBrews.fallbackBrew) {
				return s.method_7909() instanceof TaintedBloodPendantItem ? 0xC6000E : 0x989898;
			}

			int color = brew.getColor(s);
			double speed = s.method_31574(BotaniaItems.brewFlask) || s.method_31574(BotaniaItems.brewVial) ? 0.1 : 0.2;
			int add = (int) (Math.sin(ClientTickHandler.ticksInGame * speed) * 24);

			int r = Math.max(0, Math.min(255, (color >> 16 & 0xFF) + add));
			int g = Math.max(0, Math.min(255, (color >> 8 & 0xFF) + add));
			int b = Math.max(0, Math.min(255, (color & 0xFF) + add));

			return r << 16 | g << 8 | b;
		}, BotaniaItems.bloodPendant, BotaniaItems.incenseStick, BotaniaItems.brewFlask, BotaniaItems.brewVial);

		items.register((s, t) -> {
			class_1799 lens = ManaBlasterItem.getLens(s);
			if (!lens.method_7960() && t == 0) {
				return ((MinecraftAccessor) class_310.method_1551()).getItemColors().method_1704(lens, t);
			}

			if (t == 2) {
				BurstProperties props = ((ManaBlasterItem) s.method_7909()).getBurstProps(class_310.method_1551().field_1724, s, false, class_1268.field_5808);

				float mul = (float) (Math.sin((double) ClientTickHandler.ticksInGame / 5) * 0.15F);
				int c = (int) (255 * mul);

				int r = (props.color >> 16 & 0xFF) + c;
				int g = (props.color >> 8 & 0xFF) + c;
				int b = (props.color & 0xFF) + c;

				int cr = class_3532.method_15340(r, 0, 255);
				int cg = class_3532.method_15340(g, 0, 255);
				int cb = class_3532.method_15340(b, 0, 255);

				return cr << 16 | cg << 8 | cb;
			} else {
				return -1;
			}
		}, BotaniaItems.manaGun);

		items.register((s, t) -> t == 1 ? class_3532.method_15369(0.75F, 1F, 1.5F - (float) Math.min(1F, Math.sin(class_156.method_658() / 100D) * 0.5 + 1.2F)) : -1, BotaniaItems.enderDagger);

		items.register((s, t) -> t == 1 && TerraShattererItem.isEnabled(s) ? class_3532.method_15369(0.375F, (float) Math.min(1F, Math.sin(class_156.method_658() / 200D) * 0.5 + 1F), 1F) : -1, BotaniaItems.terraPick);

		class_326 lensHandler = (s, t) -> t == 0 ? ((LensItem) s.method_7909()).getLensColor(s, class_310.method_1551().field_1687) : -1;
		items.register(lensHandler, BotaniaItems.lensNormal, BotaniaItems.lensSpeed, BotaniaItems.lensPower, BotaniaItems.lensTime,
				BotaniaItems.lensEfficiency, BotaniaItems.lensBounce, BotaniaItems.lensGravity, BotaniaItems.lensMine,
				BotaniaItems.lensDamage, BotaniaItems.lensPhantom, BotaniaItems.lensMagnet, BotaniaItems.lensExplosive,
				BotaniaItems.lensInfluence, BotaniaItems.lensWeight, BotaniaItems.lensPaint, BotaniaItems.lensFire,
				BotaniaItems.lensPiston, BotaniaItems.lensLight, BotaniaItems.lensWarp, BotaniaItems.lensRedirect,
				BotaniaItems.lensFirework, BotaniaItems.lensFlare, BotaniaItems.lensMessenger, BotaniaItems.lensTripwire,
				BotaniaItems.lensStorm);
	}

	private ColorHandler() {}

}
