/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.model;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

import net.minecraft.class_5601;

public class BotaniaModelLayers {
	public static final class_5601 AVATAR = make("avatar");
	public static final class_5601 BELLOWS = make("bellows");
	public static final class_5601 BREWERY = make("brewery");
	public static final class_5601 CLOAK = make("cloak");
	public static final class_5601 CORPOREA_INDEX = make("corporea_index");
	public static final class_5601 HOURGLASS = make("hourglass");
	public static final class_5601 ELEMENTIUM_INNER_ARMOR = make("elementium_armor", "inner_armor");
	public static final class_5601 ELEMENTIUM_OUTER_ARMOR = make("elementium_armor", "outer_armor");
	public static final class_5601 MANASTEEL_INNER_ARMOR = make("manasteel_armor", "inner_armor");
	public static final class_5601 MANASTEEL_OUTER_ARMOR = make("manasteel_armor", "outer_armor");
	public static final class_5601 MANAWEAVE_INNER_ARMOR = make("manaweave_armor", "inner_armor");
	public static final class_5601 MANAWEAVE_OUTER_ARMOR = make("manaweave_armor", "outer_armor");
	public static final class_5601 PIXIE = make("pixie");
	public static final class_5601 PYLON_GAIA = make("pylon_gaia");
	public static final class_5601 PYLON_MANA = make("pylon_mana");
	public static final class_5601 PYLON_NATURA = make("pylon_natura");
	public static final class_5601 TERRASTEEL_INNER_ARMOR = make("terrasteel_armor", "inner_armor");
	public static final class_5601 TERRASTEEL_OUTER_ARMOR = make("terrasteel_armor", "outer_armor");
	public static final class_5601 TERU_TERU_BOZU = make("teru_teru_bozu");

	private static class_5601 make(String name) {
		return make(name, "main");
	}

	private static class_5601 make(String name, String layer) {
		// Don't add to vanilla's ModelLayers. It seems to only be used for error checking
		// And would be annoying to do under Forge's parallel mod loading
		return new class_5601(prefix(name), layer);
	}

	public static void init() {}
}
