/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1087;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_332;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_572;
import net.minecraft.class_811;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.handler.MiscellaneousModels;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.render.AccessoryRenderRegistry;
import vazkii.botania.client.render.AccessoryRenderer;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.helper.InventoryHelper;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.helper.StringObfuscator;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.CustomCreativeTabContents;
import vazkii.botania.common.item.StoneOfTemperanceItem;
import vazkii.botania.common.item.equipment.bauble.BaubleItem;
import vazkii.botania.common.proxy.Proxy;
import vazkii.botania.xplat.ClientXplatAbstractions;

public class FlugelTiaraItem
extends BaubleItem
implements CustomCreativeTabContents {
    private static final class_2960 textureHud = new class_2960("botania:textures/gui/hud_icons.png");
    public static final class_2960 textureHalo = new class_2960("botania:textures/misc/halo.png");
    private static final String TAG_VARIANT = "variant";
    private static final String TAG_FLYING = "flying";
    private static final String TAG_GLIDING = "gliding";
    private static final String TAG_TIME_LEFT = "timeLeft";
    private static final String TAG_INFINITE_FLIGHT = "infiniteFlight";
    private static final String TAG_DASH_COOLDOWN = "dashCooldown";
    private static final String TAG_IS_SPRINTING = "isSprinting";
    private static final String TAG_BOOST_PENDING = "boostPending";
    private static final List<String> playersWithFlight = Collections.synchronizedList(new ArrayList());
    private static final int COST = 35;
    private static final int COST_OVERKILL = 105;
    private static final int MAX_FLY_TIME = 1200;
    private static final int SUBTYPES = 8;
    public static final int WING_TYPES = 9;
    private static final String SUPER_AWESOME_HASH = "4D0F274C5E3001C95640B5E88A821422C8B1E132264492C043A3D746B705C025";

    public FlugelTiaraItem(class_1792.class_1793 props) {
        super(props);
        Proxy.INSTANCE.runOnClient(() -> () -> AccessoryRenderRegistry.register(this, new Renderer()));
    }

    @Override
    public void addToCreativeTab(class_1792 me, class_1761.class_7704 output) {
        for (int i = 0; i < 9; ++i) {
            class_1799 stack = new class_1799((class_1935)this);
            ItemNBTHelper.setInt(stack, TAG_VARIANT, i);
            output.method_45420(stack);
        }
    }

    @Override
    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 flags) {
        super.method_7851(stack, world, tooltip, flags);
        tooltip.add((class_2561)class_2561.method_43471((String)("botania.wings" + FlugelTiaraItem.getVariant(stack))));
    }

    public static void updatePlayerFlyStatus(class_1657 player) {
        class_1799 tiara = EquipmentHandler.findOrEmpty(BotaniaItems.flightTiara, (class_1309)player);
        int left = ItemNBTHelper.getInt(tiara, TAG_TIME_LEFT, 1200);
        if (playersWithFlight.contains(FlugelTiaraItem.playerStr(player))) {
            if (FlugelTiaraItem.shouldPlayerHaveFlight(player)) {
                player.method_31549().field_7478 = true;
                if (player.method_31549().field_7479) {
                    if (!player.method_37908().field_9236) {
                        if (!player.method_7337() && !player.method_7325()) {
                            ManaItemHandler.instance().requestManaExact(tiara, player, FlugelTiaraItem.getCost(tiara, left), true);
                        }
                    } else if (Math.abs(player.method_18798().method_10216()) > 0.1 || Math.abs(player.method_18798().method_10215()) > 0.1) {
                        double x = player.method_23317() - 0.5;
                        double y = player.method_23318() - 0.5;
                        double z = player.method_23321() - 0.5;
                        float r = 1.0f;
                        float g = 1.0f;
                        float b = 1.0f;
                        int variant = FlugelTiaraItem.getVariant(tiara);
                        switch (variant) {
                            case 2: {
                                r = 0.1f;
                                g = 0.1f;
                                b = 0.1f;
                                break;
                            }
                            case 3: {
                                r = 0.0f;
                                g = 0.6f;
                                break;
                            }
                            case 4: {
                                g = 0.3f;
                                b = 0.3f;
                                break;
                            }
                            case 5: {
                                r = 0.6f;
                                g = 0.0f;
                                b = 0.6f;
                                break;
                            }
                            case 6: {
                                r = 0.4f;
                                g = 0.0f;
                                b = 0.0f;
                                break;
                            }
                            case 7: {
                                r = 0.2f;
                                g = 0.6f;
                                b = 0.2f;
                                break;
                            }
                            case 8: {
                                r = 0.85f;
                                g = 0.85f;
                                b = 0.0f;
                                break;
                            }
                            case 9: {
                                r = 0.0f;
                                b = 0.0f;
                            }
                        }
                        for (int i = 0; i < 2; ++i) {
                            SparkleParticleData data = SparkleParticleData.sparkle(2.0f * (float)Math.random(), r, g, b, 20);
                            player.method_37908().method_8406((class_2394)data, x + Math.random() * (double)player.method_17681(), y + Math.random() * 0.4, z + Math.random() * (double)player.method_17681(), 0.0, 0.0, 0.0);
                        }
                    }
                }
            } else {
                if (!player.method_7325() && !player.method_31549().field_7477) {
                    player.method_31549().field_7478 = false;
                    player.method_31549().field_7479 = false;
                    player.method_31549().field_7480 = false;
                }
                playersWithFlight.remove(FlugelTiaraItem.playerStr(player));
            }
        } else if (FlugelTiaraItem.shouldPlayerHaveFlight(player)) {
            playersWithFlight.add(FlugelTiaraItem.playerStr(player));
            player.method_31549().field_7478 = true;
        }
    }

    public static void playerLoggedOut(class_3222 player) {
        String username = player.method_7334().getName();
        playersWithFlight.remove(username + ":false");
        playersWithFlight.remove(username + ":true");
    }

    private static String playerStr(class_1657 player) {
        return player.method_7334().getName() + ":" + player.method_37908().field_9236;
    }

    private static boolean shouldPlayerHaveFlight(class_1657 player) {
        class_1799 armor = EquipmentHandler.findOrEmpty(BotaniaItems.flightTiara, (class_1309)player);
        if (!armor.method_7960()) {
            int left = ItemNBTHelper.getInt(armor, TAG_TIME_LEFT, 1200);
            boolean flying = ItemNBTHelper.getBoolean(armor, TAG_FLYING, false);
            return (left > (flying ? 0 : 120) || InventoryHelper.containsType(player.method_31548(), BotaniaItems.flugelEye)) && ManaItemHandler.instance().requestManaExact(armor, player, FlugelTiaraItem.getCost(armor, left), false);
        }
        return false;
    }

    public static int getCost(class_1799 stack, int timeLeft) {
        return timeLeft <= 0 ? 105 : 35;
    }

    @Override
    public void onEquipped(class_1799 stack, class_1309 living) {
        super.onEquipped(stack, living);
        int variant = FlugelTiaraItem.getVariant(stack);
        if (variant != 9 && StringObfuscator.matchesHash(stack.method_7964().getString(), SUPER_AWESOME_HASH)) {
            ItemNBTHelper.setInt(stack, TAG_VARIANT, 9);
            stack.method_7925();
        }
    }

    @Override
    public void onWornTick(class_1799 stack, class_1309 living) {
        if (living instanceof class_1657) {
            int time;
            class_1657 player = (class_1657)living;
            boolean flying = player.method_31549().field_7479;
            boolean wasSprting = ItemNBTHelper.getBoolean(stack, TAG_IS_SPRINTING, false);
            boolean isSprinting = player.method_5624();
            if (isSprinting != wasSprting) {
                ItemNBTHelper.setBoolean(stack, TAG_IS_SPRINTING, isSprinting);
            }
            int newTime = time = ItemNBTHelper.getInt(stack, TAG_TIME_LEFT, 1200);
            class_243 look = player.method_5720().method_18805(1.0, 0.0, 1.0).method_1029();
            if (flying) {
                if (!(time <= 0 || player.method_7325() || player.method_7337() || ItemNBTHelper.getBoolean(stack, TAG_INFINITE_FLIGHT, false))) {
                    --newTime;
                }
                int maxCd = 80;
                int cooldown = ItemNBTHelper.getInt(stack, TAG_DASH_COOLDOWN, 0);
                if (!wasSprting && isSprinting && cooldown == 0 && !StoneOfTemperanceItem.hasTemperanceActive(player)) {
                    player.method_18799(player.method_18798().method_1031(look.field_1352, 0.0, look.field_1350));
                    player.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), BotaniaSounds.dash, class_3419.field_15248, 1.0f, 1.0f);
                    ItemNBTHelper.setInt(stack, TAG_DASH_COOLDOWN, 80);
                    ItemNBTHelper.setBoolean(stack, TAG_BOOST_PENDING, true);
                } else if (cooldown > 0) {
                    if (ItemNBTHelper.getBoolean(stack, TAG_BOOST_PENDING, false)) {
                        living.method_5724(5.0f, new class_243(0.0, 0.0, 1.0));
                        ItemNBTHelper.removeEntry(stack, TAG_BOOST_PENDING);
                    }
                    ItemNBTHelper.setInt(stack, TAG_DASH_COOLDOWN, cooldown - 2);
                }
            } else {
                boolean doGlide;
                boolean wasGliding = ItemNBTHelper.getBoolean(stack, TAG_GLIDING, false);
                boolean bl = doGlide = living.method_5715() && !living.method_24828() && (living.method_18798().method_10214() < (double)-0.7f || wasGliding);
                if (time < 1200 && living.field_6012 % (doGlide ? 6 : 2) == 0) {
                    ++newTime;
                }
                if (doGlide) {
                    float mul = 0.6f;
                    living.method_18800(look.field_1352 * (double)mul, Math.max((double)-0.15f, living.method_18798().method_10214()), look.field_1350 * (double)mul);
                    living.field_6017 = 2.0f;
                }
                ItemNBTHelper.setBoolean(stack, TAG_GLIDING, doGlide);
            }
            ItemNBTHelper.setBoolean(stack, TAG_FLYING, flying);
            if (newTime != time) {
                ItemNBTHelper.setInt(stack, TAG_TIME_LEFT, newTime);
            }
        }
    }

    @Override
    public boolean hasRender(class_1799 stack, class_1309 living) {
        return super.hasRender(stack, living) && living instanceof class_1657;
    }

    public static int getVariant(class_1799 stack) {
        return ItemNBTHelper.getInt(stack, TAG_VARIANT, 0);
    }

    public static class Renderer
    implements AccessoryRenderer {
        private static void renderBasic(class_572<?> bipedModel, class_1087 model, class_1799 stack, class_4587 ms, class_4597 buffers, int light, float flap) {
            ms.method_22903();
            bipedModel.field_3391.method_22703(ms);
            ms.method_22904(0.0, 0.5, 0.2);
            for (int i = 0; i < 2; ++i) {
                ms.method_22903();
                ms.method_22907(VecHelper.rotateY(i == 0 ? flap : 180.0f - flap));
                ms.method_46416(-1.0f, 0.0f, 0.0f);
                ms.method_22907(VecHelper.rotateZ(-60.0f));
                ms.method_22905(1.5f, -1.5f, -1.5f);
                class_310.method_1551().method_1480().method_23179(stack, class_811.field_4315, false, ms, buffers, light, class_4608.field_21444, model);
                ms.method_22909();
            }
            ms.method_22909();
        }

        private static void renderSephiroth(class_572<?> bipedModel, class_1087 model, class_1799 stack, class_4587 ms, class_4597 buffers, int light, float flap) {
            ms.method_22903();
            bipedModel.field_3391.method_22703(ms);
            ms.method_22904(0.0, 0.5, 0.2);
            ms.method_22907(VecHelper.rotateY(flap));
            ms.method_22904(-1.1, 0.0, 0.0);
            ms.method_22907(VecHelper.rotateZ(-60.0f));
            ms.method_22905(1.6f, -1.6f, -1.6f);
            class_310.method_1551().method_1480().method_23179(stack, class_811.field_4315, false, ms, buffers, light, class_4608.field_21444, model);
            ms.method_22909();
        }

        private static void renderCirno(class_572<?> bipedModel, class_1087 model, class_1799 stack, class_4587 ms, class_4597 buffers, int light) {
            ms.method_22903();
            bipedModel.field_3391.method_22703(ms);
            ms.method_22904(-0.8, 0.15, 0.25);
            for (int i = 0; i < 2; ++i) {
                ms.method_22903();
                if (i == 1) {
                    ms.method_22907(VecHelper.rotateY(180.0f));
                    ms.method_22904(-1.6, 0.0, 0.0);
                }
                ms.method_22905(1.6f, -1.6f, -1.6f);
                class_310.method_1551().method_1480().method_23179(stack, class_811.field_4315, false, ms, buffers, light, class_4608.field_21444, model);
                ms.method_22909();
            }
            ms.method_22909();
        }

        private static void renderPhoenix(class_572<?> bipedModel, class_1087 model, class_1799 stack, class_4587 ms, class_4597 buffers, float flap) {
            ms.method_22903();
            bipedModel.field_3391.method_22703(ms);
            ms.method_22904(0.0, -0.2, 0.2);
            for (int i = 0; i < 2; ++i) {
                ms.method_22903();
                ms.method_22907(VecHelper.rotateY(i == 0 ? flap : 180.0f - flap));
                ms.method_22904(-0.9, 0.0, 0.0);
                ms.method_22905(1.7f, -1.7f, -1.7f);
                class_310.method_1551().method_1480().method_23179(stack, class_811.field_4315, false, ms, buffers, 0xF000F0, class_4608.field_21444, model);
                ms.method_22909();
            }
            ms.method_22909();
        }

        private static void renderKuroyukihime(class_572<?> bipedModel, class_1087 model, class_1799 stack, class_4587 ms, class_4597 buffers, float flap) {
            ms.method_22903();
            bipedModel.field_3391.method_22703(ms);
            ms.method_22904(0.0, -0.4, 0.2);
            for (int i = 0; i < 2; ++i) {
                ms.method_22903();
                ms.method_22907(VecHelper.rotateY(i == 0 ? flap : 180.0f - flap));
                ms.method_22904(-1.3, 0.0, 0.0);
                ms.method_22905(2.5f, -2.5f, -2.5f);
                class_310.method_1551().method_1480().method_23179(stack, class_811.field_4315, false, ms, buffers, 0xF000F0, class_4608.field_21444, model);
                ms.method_22909();
            }
            ms.method_22909();
        }

        private static void renderCustomColor(class_572<?> bipedModel, class_1087 model, class_1309 living, class_1799 stack, class_4587 ms, class_4597 buffers, float flap, int color) {
            ms.method_22903();
            bipedModel.field_3391.method_22703(ms);
            ms.method_22904(0.0, 0.0, 0.2);
            for (int i = 0; i < 2; ++i) {
                ms.method_22903();
                ms.method_22907(VecHelper.rotateY(i == 0 ? flap : 180.0f - flap));
                ms.method_22904(-0.7, 0.0, 0.0);
                ms.method_22905(1.5f, -1.5f, -1.5f);
                RenderHelper.renderItemCustomColor(living, stack, color, ms, buffers, 0xF000F0, class_4608.field_21444, model);
                ms.method_22909();
            }
            ms.method_22909();
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void doRender(class_572<?> bipedModel, class_1799 stack, class_1309 living, class_4587 ms, class_4597 buffers, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            meta = FlugelTiaraItem.getVariant(stack);
            if (meta <= 0 || meta >= MiscellaneousModels.INSTANCE.tiaraWingIcons.length + 1) {
                return;
            }
            model = MiscellaneousModels.INSTANCE.tiaraWingIcons[meta - 1];
            ClientXplatAbstractions.instance().markSpriteActive(model.method_4711());
            if (!(living instanceof class_1657)) ** GOTO lbl-1000
            player = (class_1657)living;
            if (player.method_31549().field_7479) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            flying = v0;
            flap = 20.0f + (float)((Math.sin((double)((float)living.field_6012 + partialTicks) * (double)(flying != false ? 0.4f : 0.2f)) + 0.5) * (double)(flying != false ? 30.0f : 5.0f));
            switch (meta) {
                case 1: {
                    Renderer.renderBasic(bipedModel, model, stack, ms, buffers, light, flap);
                    ms.method_22903();
                    ClientLogic.renderHalo(bipedModel, living, ms, buffers, partialTicks);
                    ms.method_22909();
                    break;
                }
                case 2: {
                    Renderer.renderSephiroth(bipedModel, model, stack, ms, buffers, light, flap);
                    break;
                }
                case 3: {
                    Renderer.renderCirno(bipedModel, model, stack, ms, buffers, light);
                    break;
                }
                case 4: {
                    Renderer.renderPhoenix(bipedModel, model, stack, ms, buffers, flap);
                    break;
                }
                case 5: {
                    Renderer.renderKuroyukihime(bipedModel, model, stack, ms, buffers, flap);
                    break;
                }
                case 6: 
                case 8: {
                    Renderer.renderBasic(bipedModel, model, stack, ms, buffers, light, flap);
                    break;
                }
                case 7: {
                    alpha = 0.5f + (float)Math.cos((double)((float)living.field_6012 + partialTicks) * 0.30000001192092896) * 0.2f;
                    color = 0xFFFFFF | (int)(alpha * 255.0f) << 24;
                    Renderer.renderCustomColor(bipedModel, model, living, stack, ms, buffers, flap, color);
                    break;
                }
                case 9: {
                    flap = -((float)((Math.sin((double)((float)living.field_6012 + partialTicks) * 0.20000000298023224) + 0.6000000238418579) * (double)(flying != false ? 12.0f : 5.0f)));
                    alpha = 0.5f + (flying != false ? (float)Math.cos((double)((float)living.field_6012 + partialTicks) * 0.30000001192092896) * 0.25f + 0.25f : 0.0f);
                    color = 0xFFFFFF | (int)(alpha * 255.0f) << 24;
                    Renderer.renderCustomColor(bipedModel, model, living, stack, ms, buffers, flap, color);
                }
            }
        }
    }

    public static class ClientLogic {
        public static void renderHalo(@Nullable class_572<?> model, @Nullable class_1309 living, class_4587 ms, class_4597 buffers, float partialTicks) {
            if (model != null) {
                model.field_3391.method_22703(ms);
            }
            ms.method_22904(0.2, -0.65, 0.0);
            ms.method_22907(VecHelper.rotateZ(30.0f));
            if (living != null) {
                ms.method_22907(VecHelper.rotateY((float)living.field_6012 + partialTicks));
            } else {
                ms.method_22907(VecHelper.rotateY(ClientTickHandler.ticksInGame));
            }
            ms.method_22905(0.75f, -0.75f, -0.75f);
            class_4588 buffer = buffers.getBuffer(RenderHelper.HALO);
            Matrix4f mat = ms.method_23760().method_23761();
            buffer.method_22918(mat, -1.0f, 0.0f, -1.0f).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(0.0f, 0.0f).method_1344();
            buffer.method_22918(mat, 1.0f, 0.0f, -1.0f).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(1.0f, 0.0f).method_1344();
            buffer.method_22918(mat, 1.0f, 0.0f, 1.0f).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(1.0f, 1.0f).method_1344();
            buffer.method_22918(mat, -1.0f, 0.0f, 1.0f).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(0.0f, 1.0f).method_1344();
        }

        private static int estimateAdditionalNumRowsRendered(class_1657 player) {
            class_1309 vehicle;
            if (player.method_5777(class_3486.field_15517) || player.method_5669() < player.method_5748()) {
                return 1;
            }
            class_1297 playerVehicle = player.method_5854();
            if (playerVehicle instanceof class_1309 && (vehicle = (class_1309)playerVehicle).method_5709()) {
                return (Math.min(30, (int)((double)vehicle.method_6063() + 0.5) / 2) - 1) / 10;
            }
            return 0;
        }

        public static void renderHUD(class_332 gui, class_1657 player, class_1799 stack) {
            int u = Math.max(1, FlugelTiaraItem.getVariant(stack)) * 9 - 9;
            int v = 0;
            class_310 mc = class_310.method_1551();
            int xo = mc.method_22683().method_4486() / 2 + 10;
            int y = mc.method_22683().method_4502() - 10 * ClientLogic.estimateAdditionalNumRowsRendered(player) - 49;
            int left = ItemNBTHelper.getInt(stack, FlugelTiaraItem.TAG_TIME_LEFT, 1200);
            int segTime = 120;
            int segs = left / segTime + 1;
            int last = left % segTime;
            for (int i = 0; i < segs; ++i) {
                float trans = 1.0f;
                if (i == segs - 1) {
                    trans = (float)last / (float)segTime;
                    RenderSystem.enableBlend();
                    RenderSystem.blendFunc((int)770, (int)771);
                }
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)trans);
                RenderHelper.drawTexturedModalRect(gui, textureHud, xo + 8 * i, y, u, v, 9, 9);
            }
            if (player.method_31549().field_7479) {
                int width = ItemNBTHelper.getInt(stack, FlugelTiaraItem.TAG_DASH_COOLDOWN, 0);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (width > 0) {
                    gui.method_25294(xo, y - 2, xo + 80, y - 1, -2013265920);
                }
                gui.method_25294(xo, y - 2, xo + width, y - 1, -1);
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

