/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.jei.orechid;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3956;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.recipe.OrechidRecipe;
import vazkii.botania.client.integration.shared.OrechidUIHelper;
import vazkii.botania.common.lib.ResourceLocationHelper;

public abstract class OrechidRecipeCategoryBase<T extends OrechidRecipe>
implements IRecipeCategory<T> {
    private final IDrawableStatic background;
    private final class_2561 localizedName;
    private final IDrawableStatic overlay;
    private final IDrawable icon;
    private final class_1799 iconStack;

    public OrechidRecipeCategoryBase(IGuiHelper guiHelper, class_1799 iconStack, class_2561 localizedName) {
        this.overlay = guiHelper.createDrawable(ResourceLocationHelper.prefix("textures/gui/pure_daisy_overlay.png"), 0, 0, 64, 44);
        this.background = guiHelper.createBlankDrawable(96, 44);
        this.localizedName = localizedName;
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)iconStack);
        this.iconStack = iconStack;
    }

    @NotNull
    public class_2561 getTitle() {
        return this.localizedName;
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    protected abstract class_3956<T> recipeType();

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull OrechidRecipe recipe, @NotNull IFocusGroup focusGroup) {
        builder.addSlot(RecipeIngredientRole.INPUT, 9, 12).addItemStacks(recipe.getInput().getDisplayedStacks());
        builder.addSlot(RecipeIngredientRole.CATALYST, 39, 12).addItemStack(this.iconStack);
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 68, 12).addItemStacks(recipe.getOutput().getDisplayedStacks())).addTooltipCallback((view, tooltip) -> tooltip.addAll(recipe.getOutput().descriptionTooltip()));
    }

    public void draw(@NotNull OrechidRecipe recipe, @NotNull IRecipeSlotsView view, @NotNull class_332 gui, double mouseX, double mouseY) {
        Double chance = this.getChance(recipe);
        if (chance != null) {
            class_2561 chanceComponent = OrechidUIHelper.getPercentageComponent(chance);
            class_327 font = class_310.method_1551().field_1772;
            int xOffset = 90 - font.method_27525((class_5348)chanceComponent);
            gui.method_51439(font, chanceComponent, xOffset, 1, 0x888888, false);
        }
        RenderSystem.enableBlend();
        this.overlay.draw(gui, 17, 0);
        RenderSystem.disableBlend();
    }

    @NotNull
    public List<class_2561> getTooltipStrings(@NotNull OrechidRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        Double chance;
        if (mouseX > 0.6 * (double)this.background.getWidth() && mouseX < 90.0 && mouseY < 12.0 && (chance = this.getChance(recipe)) != null) {
            return this.getChanceTooltipComponents(chance, recipe).toList();
        }
        return Collections.emptyList();
    }

    @NotNull
    protected Stream<class_2561> getChanceTooltipComponents(double chance, @NotNull OrechidRecipe recipe) {
        IntIntPair ratio = OrechidUIHelper.getRatioForChance(chance);
        return Stream.of(OrechidUIHelper.getRatioTooltipComponent(ratio));
    }

    @Nullable
    protected Double getChance(@NotNull OrechidRecipe recipe) {
        return OrechidUIHelper.getChance(recipe, null);
    }
}

