package vazkii.botania.test.block;

import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_4512;
import net.minecraft.class_4516;
import net.minecraft.class_6302;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.ForceRelayBlock;
import vazkii.botania.common.block.ForceRelayBlock.WorldData;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.mana.ManaSpreaderBlockEntity;
import vazkii.botania.common.block.flower.generating.EntropinnyumBlockEntity;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.test.TestingUtil;

public class EntropinnyumUnethicalTntDetectionTest {
	private static final String TEMPLATE_SLIME_DUPER_FORCE_LENS = "botania:block/entropinnyum_unethical_slime_duper_force_lens";
	private static final String TEMPLATE_SLIME_DUPER_FORCE_RELAY = "botania:block/entropinnyum_unethical_slime_duper_force_relay";
	private static final String TEMPLATE_ENTITYLESS_DUPER = "botania:block/entropinnyum_unethical_entityless_duper";
	private static final String TEMPLATE_LEGIT_TNT = "botania:block/entropinnyum_ethical_tnt_block";

	private static final class_2338 POSITION_ENTROPINNYUM = new class_2338(9, 1, 9);

	private static final class_2338 POSITION_FORCE_LENS_DETECTOR_RAIL = new class_2338(7, 16, 10);
	private static final class_2338 POSITION_FORCE_LENS_PUSHED_SLIME_BLOCK = new class_2338(6, 16, 10);
	private static final class_2338 POSITION_FORCE_LENS_MANA_SPREADER = new class_2338(5, 16, 10);
	private static final class_2338 POSITION_FORCE_LENS_BUTTON = new class_2338(5, 16, 8);

	private static final class_2338 POSITION_FORCE_RELAY_DETECTOR_RAIL = new class_2338(4, 4, 10);
	private static final class_2338 POSITION_FORCE_RELAY_PUSHED_SLIME_BLOCK = new class_2338(3, 4, 10);
	private static final class_2338 POSITION_FORCE_RELAY = new class_2338(4, 3, 6);
	private static final class_2338 POSITION_FORCE_RELAY_BUTTON = new class_2338(2, 4, 5);

	private static final class_2338 POSITION_ENTITYLESS_DUPER_BUTTON = new class_2338(3, 13, 10);

	private static final class_2338 POSITION_ETHICAL_TNT_BLOCK_BUTTON = new class_2338(9, 4, 9);

	private static Runnable checkEntropinnyumForUnethicalManaAmount(class_4516 helper) {
		return () -> {
			final var be = helper.method_36014(POSITION_ENTROPINNYUM);
			if (!(be instanceof EntropinnyumBlockEntity entropinnyum)) {
				throw new class_4512("Missing Entropinnyum at: " + POSITION_ENTROPINNYUM);
			}
			if (entropinnyum.getMana() != 3) {
				throw new class_4512("Wrong amount of mana: expected " + 3 + " but was " + entropinnyum.getMana());
			}
		};
	}

	@class_6302(method_35936 = TEMPLATE_SLIME_DUPER_FORCE_LENS, method_35932 = 150)
	public void testForceLensDuper(class_4516 helper) {
		helper.method_36041()
				.method_36085(() -> {
					var player = helper.method_36021();
					var spreader = TestingUtil.assertBlockEntity(helper, POSITION_FORCE_LENS_MANA_SPREADER, BotaniaBlockEntities.SPREADER);
					TestingUtil.assertThat(spreader.bindTo(player, new class_1799(BotaniaItems.twigWand),
							helper.method_36052(POSITION_FORCE_LENS_PUSHED_SLIME_BLOCK), class_2350.field_11036),
							() -> "Failed to bind spreader");

					if (helper.method_35980(POSITION_FORCE_LENS_DETECTOR_RAIL).method_26204() != class_2246.field_10025) {
						throw new class_4512("Missing detector rail at: " +
								POSITION_FORCE_LENS_DETECTOR_RAIL);
					}
					helper.method_35964(class_1299.field_6096, POSITION_FORCE_LENS_DETECTOR_RAIL);
					helper.method_36026(POSITION_FORCE_LENS_BUTTON);
				})
				.method_36077(130, checkEntropinnyumForUnethicalManaAmount(helper))
				.method_36075();
	}

	@class_6302(method_35936 = TEMPLATE_SLIME_DUPER_FORCE_RELAY)
	public void testForceRelayDuper(class_4516 helper) {
		helper.method_36041()
				.method_36085(() -> {
					if (helper.method_35980(POSITION_FORCE_RELAY).method_26204() != BotaniaBlocks.pistonRelay) {
						throw new class_4512("Missing force relay at: " + POSITION_FORCE_RELAY);
					}
					var data = ForceRelayBlock.WorldData.get(helper.method_35943());
					data.mapping.put(helper.method_36052(POSITION_FORCE_RELAY), helper.method_36052(
							POSITION_FORCE_RELAY_PUSHED_SLIME_BLOCK));

					if (helper.method_35980(POSITION_FORCE_RELAY_DETECTOR_RAIL).method_26204() != class_2246.field_10025) {
						throw new class_4512("Missing detector rail at: " +
								POSITION_FORCE_RELAY_DETECTOR_RAIL);
					}
					helper.method_35964(class_1299.field_6096, POSITION_FORCE_RELAY_DETECTOR_RAIL);
				})
				.method_36077(1, () -> helper.method_36026(POSITION_FORCE_RELAY_BUTTON))
				.method_36077(90, checkEntropinnyumForUnethicalManaAmount(helper))
				.method_36075();
	}

	@class_6302(method_35936 = TEMPLATE_ENTITYLESS_DUPER)
	public void testEntitylessDuper(class_4516 helper) {
		helper.method_36041()
				.method_36085(() -> helper.method_36026(POSITION_ENTITYLESS_DUPER_BUTTON))
				.method_36077(95, checkEntropinnyumForUnethicalManaAmount(helper))
				.method_36075();
	}

	@class_6302(method_35936 = TEMPLATE_LEGIT_TNT)
	public void testLegitimateTnt(class_4516 helper) {
		helper.method_36041()
				.method_36085(() -> helper.method_36026(POSITION_ETHICAL_TNT_BLOCK_BUTTON))
				.method_36077(95, () -> {
					final var be = helper.method_36014(POSITION_ENTROPINNYUM);
					if (!(be instanceof EntropinnyumBlockEntity entropinnyum)) {
						throw new class_4512("Missing Entropinnyum at: " + POSITION_ENTROPINNYUM);
					}
					if (entropinnyum.getMana() != entropinnyum.getMaxMana()) {
						throw new class_4512("Wrong amount of mana: expected " + entropinnyum.getMaxMana() + " but was " + entropinnyum.getMana());
					}
				})
				.method_36075();
	}
}
