/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.data.recipes;

import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.class_2405;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_7403;
import net.minecraft.class_7784;

public abstract class BotaniaRecipeProvider implements class_2405 {
	private final class_7784.class_7489 recipePathProvider;
	private final class_7784.class_7489 advancementPathProvider;

	public BotaniaRecipeProvider(class_7784 packOutput) {
		this.recipePathProvider = packOutput.method_45973(class_7784.class_7490.field_39367, "recipes");
		this.advancementPathProvider = packOutput.method_45973(class_7784.class_7490.field_39367, "advancements");
	}

	// [VanillaCopy] RecipeProvider
	@Override
	public @NotNull CompletableFuture<?> method_10319(@NotNull class_7403 cache) {
		Set<class_2960> checkDuplicates = Sets.newHashSet();
		List<CompletableFuture<?>> output = new ArrayList<>();
		buildRecipes((recipe) -> {
			if (!checkDuplicates.add(recipe.method_10417())) {
				throw new IllegalStateException("Duplicate recipe " + recipe.method_10417());
			} else {
				output.add(class_2405.method_10320(cache, recipe.method_17799(), recipePathProvider.method_44107(recipe.method_10417())));
				JsonObject advancement = recipe.method_10415();
				if (advancement != null) {
					output.add(class_2405.method_10320(cache, advancement, advancementPathProvider.method_44107(recipe.method_10418())));
				}
			}
		});
		return CompletableFuture.allOf(output.toArray(CompletableFuture[]::new));
	}

	protected abstract void buildRecipes(Consumer<class_2444> consumer);
}
