/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.tool.elementium;

import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.annotations.SoftImplement;
import vazkii.botania.common.item.equipment.tool.manasteel.ManasteelAxeItem;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_2960;

public class ElementiumAxeItem extends ManasteelAxeItem {
	public static final class_2960 BEHEADING_LOOT_TABLE = prefix("elementium_axe_beheading");

	public ElementiumAxeItem(class_1793 props) {
		super(BotaniaAPI.instance().getElementiumItemTier(), 6F, -3.1F, props);
	}

	@SoftImplement("IForgeItem")
	public boolean canApplyAtEnchantingTable(class_1799 stack, class_1887 enchantment) {
		if (enchantment == class_1893.field_9110) {
			return true;
		} else {
			// Copy the default impl
			return enchantment.field_9083.method_8177(this);
		}

	}

	// [VanillaCopy] modified from DiggerItem::hurtEnemy, actually same as SwordItem::hurtEnemy
	@Override
	public boolean method_7873(class_1799 stack, @NotNull class_1309 target, @NotNull class_1309 attacker) {
		// only do 1 durability damage, since this is primarily a weapon
		stack.method_7956(1, attacker, living -> living.method_20235(class_1304.field_6173));
		return true;
	}

}
