/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.handler;

import java.util.Optional;
import net.minecraft.class_1860;
import net.minecraft.class_1863.class_7266;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2609;
import net.minecraft.class_2741;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.block.ExoflameHeatable;
import vazkii.botania.mixin.AbstractFurnaceBlockEntityAccessor;
import vazkii.botania.xplat.XplatAbstractions;

public class ExoflameFurnaceHandler {
	public static boolean canSmeltRecipe(class_2609 furnace, class_1860<?> recipe) {
		var items = ((AbstractFurnaceBlockEntityAccessor) furnace).getItems();
		return XplatAbstractions.INSTANCE.canFurnaceBurn(furnace, recipe, items, furnace.method_5444());
	}

	public static boolean canSmelt(class_2609 furnace) {
		if (furnace.method_5438(0).method_7960()) {
			return false;
		}
		try {
			var qc = ((AbstractFurnaceBlockEntityAccessor) furnace).getQuickCheck();
			var currentRecipe = qc.method_42303(furnace, furnace.method_10997());
			return currentRecipe.isPresent() && ExoflameFurnaceHandler.canSmeltRecipe(furnace, currentRecipe.get());
		} catch (Throwable t) {
			BotaniaAPI.LOGGER.error("Failed to determine if furnace TE can smelt", t);
			return false;
		}
	}

	public static class FurnaceExoflameHeatable implements ExoflameHeatable {
		private final class_2609 furnace;

		public FurnaceExoflameHeatable(class_2609 furnace) {
			this.furnace = furnace;
		}

		@Override
		public boolean canSmelt() {
			return ExoflameFurnaceHandler.canSmelt(furnace);
		}

		@Override
		public int getBurnTime() {
			return ((AbstractFurnaceBlockEntityAccessor) furnace).getLitTime();
		}

		@Override
		public void boostBurnTime() {
			if (getBurnTime() == 0) {
				class_1937 world = furnace.method_10997();
				class_2338 pos = furnace.method_11016();
				world.method_8501(pos, world.method_8320(pos).method_11657(class_2741.field_12548, true));
			}
			int burnTime = ((AbstractFurnaceBlockEntityAccessor) furnace).getLitTime();
			((AbstractFurnaceBlockEntityAccessor) furnace).setLitTime(burnTime + 200);
		}

		@Override
		public void boostCookTime() {
			int cookTime = ((AbstractFurnaceBlockEntityAccessor) furnace).getCookingProgress();
			int cookTimeTotal = ((AbstractFurnaceBlockEntityAccessor) furnace).getCookingTotalTime();
			((AbstractFurnaceBlockEntityAccessor) furnace).setCookingProgress(Math.min(cookTimeTotal - 1, cookTime + 1));
		}
	}
}
