/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.impl;

import com.google.common.collect.Maps;
import vazkii.botania.api.BotaniaAPIClient;
import vazkii.botania.api.block.FloatingFlower;
import vazkii.botania.client.gui.HUDHandler;

import java.util.Collections;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_332;

public class BotaniaAPIClientImpl implements BotaniaAPIClient {
	private final Map<FloatingFlower.IslandType, class_2960> islandTypeModels = Maps.newHashMap();

	@Override
	public void registerIslandTypeModel(FloatingFlower.IslandType islandType, class_2960 model) {
		islandTypeModels.put(islandType, model);
	}

	@Override
	public Map<FloatingFlower.IslandType, class_2960> getRegisteredIslandTypeModels() {
		return Collections.unmodifiableMap(islandTypeModels);
	}

	@Override
	public void drawSimpleManaHUD(class_332 gui, int color, int mana, int maxMana, String name) {
		HUDHandler.drawSimpleManaHUD(gui, color, mana, maxMana, name);
	}

	@Override
	public void drawComplexManaHUD(class_332 gui, int color, int mana, int maxMana, String name, class_1799 bindDisplay, boolean properlyBound) {
		HUDHandler.drawComplexManaHUD(color, gui, mana, maxMana, name, bindDisplay, properlyBound);
	}
}
