/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data;

import com.google.gson.JsonElement;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1299;
import net.minecraft.class_173;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_39;
import net.minecraft.class_52;
import net.minecraft.class_5270;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.class_7058;
import net.minecraft.class_7403;
import net.minecraft.class_77;
import net.minecraft.class_7784;
import net.minecraft.class_79;
import net.minecraft.class_83;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class LooniumStructureLootProvider
implements class_2405 {
    public static final EnumSet<VillageLoot> PLAINS_VILLAGE_LOOT = EnumSet.of(VillageLoot.CARTOGRAPHER, VillageLoot.FISHER, VillageLoot.TANNERY, VillageLoot.WEAPONSMITH);
    public static final EnumSet<VillageLoot> DESERT_VILLAGE_LOOT = EnumSet.of(VillageLoot.TEMPLE, VillageLoot.TOOLSMITH, VillageLoot.WEAPONSMITH);
    public static final EnumSet<VillageLoot> SAVANNA_VILLAGE_LOOT = EnumSet.of(VillageLoot.BUTCHER, VillageLoot.CARTOGRAPHER, VillageLoot.MASON, VillageLoot.TANNERY, VillageLoot.WEAPONSMITH);
    public static final EnumSet<VillageLoot> SNOWY_VILLAGE_LOOT = EnumSet.of(VillageLoot.ARMORER, VillageLoot.CARTOGRAPHER, VillageLoot.SHEPHERD, VillageLoot.TANNERY, VillageLoot.WEAPONSMITH);
    public static final EnumSet<VillageLoot> TAIGA_VILLAGE_LOOT = EnumSet.of(VillageLoot.CARTOGRAPHER, VillageLoot.FLETCHER, VillageLoot.TANNERY, VillageLoot.TOOLSMITH, VillageLoot.WEAPONSMITH);
    private final class_7784.class_7489 pathProvider;

    public LooniumStructureLootProvider(class_7784 packOutput) {
        this.pathProvider = packOutput.method_45973(class_7784.class_7490.field_39367, "loot_tables/loonium");
    }

    public static class_2960 getStructureId(class_5321<class_3195> structureKey) {
        return LooniumStructureLootProvider.getStructureId(structureKey.method_29177());
    }

    public static class_2960 getStructureId(class_2960 structureId) {
        return ResourceLocationHelper.prefix("%s/%s".formatted(structureId.method_12836(), structureId.method_12832()));
    }

    @NotNull
    public CompletableFuture<?> method_10319(@NotNull class_7403 cache) {
        HashMap<class_2960, class_52.class_53> tables = new HashMap<class_2960, class_52.class_53>();
        this.addLootTables(tables);
        ArrayList<CompletableFuture> output = new ArrayList<CompletableFuture>(tables.size());
        for (Map.Entry e : tables.entrySet()) {
            Path path = this.pathProvider.method_44107((class_2960)e.getKey());
            class_52.class_53 builder = (class_52.class_53)e.getValue();
            class_52 lootTable = builder.method_334(class_173.field_1177).method_338();
            JsonElement jsonTree = class_5270.method_27862().create().toJsonTree((Object)lootTable);
            output.add(class_2405.method_10320((class_7403)cache, (JsonElement)jsonTree, (Path)path));
        }
        return CompletableFuture.allOf((CompletableFuture[])output.toArray(CompletableFuture[]::new));
    }

    private void addLootTables(Map<class_2960, class_52.class_53> tables) {
        tables.put(ResourceLocationHelper.prefix("default"), LooniumStructureLootProvider.buildDelegateLootTable(class_39.field_356));
        tables.put(LooniumStructureLootProvider.getStructureId((class_5321<class_3195>)class_7058.field_38428), class_52.method_324().method_336(class_55.method_347().method_351((class_79.class_80)class_83.method_428((class_2960)class_39.field_38438).method_437(9)).method_351((class_79.class_80)class_83.method_428((class_2960)class_39.field_38439).method_437(1))));
        tables.put(LooniumStructureLootProvider.getStructureId((class_5321<class_3195>)class_7058.field_37186), class_52.method_324().method_336(class_55.method_347().method_351((class_79.class_80)class_83.method_428((class_2960)class_39.field_24048).method_437(1)).method_351((class_79.class_80)class_83.method_428((class_2960)class_39.field_24049).method_437(1)).method_351((class_79.class_80)class_83.method_428((class_2960)class_39.field_24046).method_437(1)).method_351((class_79.class_80)class_83.method_428((class_2960)class_39.field_24047).method_437(7))));
        tables.put(LooniumStructureLootProvider.getStructureId((class_5321<class_3195>)class_7058.field_37185), LooniumStructureLootProvider.buildDelegateLootTable(class_39.field_251));
        tables.put(LooniumStructureLootProvider.getStructureId((class_5321<class_3195>)class_7058.field_37173), class_52.method_324().method_336(class_55.method_347().method_351((class_79.class_80)class_83.method_428((class_2960)class_39.field_885).method_437(37)).method_351((class_79.class_80)class_83.method_428((class_2960)class_39.field_43354).method_437(2)).method_351((class_79.class_80)class_83.method_428((class_2960)class_39.field_43353))));
        tables.put(LooniumStructureLootProvider.getStructureId((class_5321<class_3195>)class_7058.field_37184), class_52.method_324().method_336(class_55.method_347().method_351((class_79.class_80)class_83.method_428((class_2960)class_39.field_274).method_437(49)).method_351((class_79.class_80)class_77.method_411((class_1935)class_1802.field_8833))));
        tables.put(LooniumStructureLootProvider.getStructureId((class_5321<class_3195>)class_7058.field_37182), LooniumStructureLootProvider.buildDelegateLootTable(class_39.field_615));
        tables.put(LooniumStructureLootProvider.getStructureId((class_5321<class_3195>)class_7058.field_37172), class_52.method_324().method_336(class_55.method_347().method_351((class_79.class_80)class_83.method_428((class_2960)class_39.field_803).method_437(9)).method_351((class_79.class_80)class_83.method_428((class_2960)class_39.field_751))));
        tables.put(LooniumStructureLootProvider.getStructureId((class_5321<class_3195>)class_7058.field_37169), LooniumStructureLootProvider.buildDelegateLootTable(class_39.field_472));
        tables.put(LooniumStructureLootProvider.getStructureId((class_5321<class_3195>)class_7058.field_37170), LooniumStructureLootProvider.buildDelegateLootTable(class_39.field_472));
        tables.put(LooniumStructureLootProvider.getStructureId((class_5321<class_3195>)class_7058.field_37179), class_52.method_324().method_336(class_55.method_347().method_351((class_79.class_80)class_83.method_428((class_2960)class_1299.field_6086.method_16351()).method_437(5)).method_351((class_79.class_80)class_77.method_411((class_1935)class_1802.field_8554))));
        tables.put(LooniumStructureLootProvider.getStructureId((class_5321<class_3195>)class_7058.field_37180), LooniumStructureLootProvider.buildOceanRuinLootTable(class_39.field_43357));
        tables.put(LooniumStructureLootProvider.getStructureId((class_5321<class_3195>)class_7058.field_37181), LooniumStructureLootProvider.buildOceanRuinLootTable(class_39.field_43356));
        tables.put(LooniumStructureLootProvider.getStructureId((class_5321<class_3195>)class_7058.field_37168), LooniumStructureLootProvider.buildDelegateLootTable(class_39.field_16593));
        tables.put(LooniumStructureLootProvider.getStructureId((class_5321<class_3195>)class_7058.field_37193), LooniumStructureLootProvider.buildDelegateLootTable(class_39.field_24050));
        tables.put(LooniumStructureLootProvider.getStructureId((class_5321<class_3195>)class_7058.field_37163), LooniumStructureLootProvider.buildDelegateLootTable(class_39.field_24050));
        tables.put(LooniumStructureLootProvider.getStructureId((class_5321<class_3195>)class_7058.field_37165), LooniumStructureLootProvider.buildDelegateLootTable(class_39.field_24050));
        tables.put(LooniumStructureLootProvider.getStructureId((class_5321<class_3195>)class_7058.field_37167), LooniumStructureLootProvider.buildDelegateLootTable(class_39.field_24050));
        tables.put(LooniumStructureLootProvider.getStructureId((class_5321<class_3195>)class_7058.field_37166), LooniumStructureLootProvider.buildDelegateLootTable(class_39.field_24050));
        tables.put(LooniumStructureLootProvider.getStructureId((class_5321<class_3195>)class_7058.field_37192), LooniumStructureLootProvider.buildDelegateLootTable(class_39.field_24050));
        tables.put(LooniumStructureLootProvider.getStructureId((class_5321<class_3195>)class_7058.field_37164), LooniumStructureLootProvider.buildDelegateLootTable(class_39.field_24050));
        tables.put(LooniumStructureLootProvider.getStructureId((class_5321<class_3195>)class_7058.field_37175), LooniumStructureLootProvider.buildShipwreckLootTable());
        tables.put(LooniumStructureLootProvider.getStructureId((class_5321<class_3195>)class_7058.field_37176), LooniumStructureLootProvider.buildShipwreckLootTable());
        tables.put(LooniumStructureLootProvider.getStructureId((class_5321<class_3195>)class_7058.field_37178), class_52.method_324().method_336(class_55.method_347().method_351((class_79.class_80)class_83.method_428((class_2960)class_39.field_842).method_437(4)).method_351((class_79.class_80)class_83.method_428((class_2960)class_39.field_800).method_437(6)).method_351((class_79.class_80)class_83.method_428((class_2960)class_39.field_683).method_437(3))));
        tables.put(LooniumStructureLootProvider.getStructureId((class_5321<class_3195>)class_7058.field_43326), class_52.method_324().method_336(class_55.method_347().method_351((class_79.class_80)class_83.method_428((class_2960)class_39.field_44648).method_437(9)).method_351((class_79.class_80)class_83.method_428((class_2960)class_39.field_44649))));
        tables.put(LooniumStructureLootProvider.getStructureId((class_5321<class_3195>)class_7058.field_37187), LooniumStructureLootProvider.buildVillageLootTable(class_39.field_16748, PLAINS_VILLAGE_LOOT));
        tables.put(LooniumStructureLootProvider.getStructureId((class_5321<class_3195>)class_7058.field_37188), LooniumStructureLootProvider.buildVillageLootTable(class_39.field_16752, DESERT_VILLAGE_LOOT));
        tables.put(LooniumStructureLootProvider.getStructureId((class_5321<class_3195>)class_7058.field_37189), LooniumStructureLootProvider.buildVillageLootTable(class_39.field_16753, SAVANNA_VILLAGE_LOOT));
        tables.put(LooniumStructureLootProvider.getStructureId((class_5321<class_3195>)class_7058.field_37190), LooniumStructureLootProvider.buildVillageLootTable(class_39.field_16754, SNOWY_VILLAGE_LOOT));
        tables.put(LooniumStructureLootProvider.getStructureId((class_5321<class_3195>)class_7058.field_37191), LooniumStructureLootProvider.buildVillageLootTable(class_39.field_16749, TAIGA_VILLAGE_LOOT));
        tables.put(LooniumStructureLootProvider.getStructureId((class_5321<class_3195>)class_7058.field_37171), class_52.method_324().method_336(class_55.method_347().method_351((class_79.class_80)class_83.method_428((class_2960)class_39.field_484).method_437(99)).method_351((class_79.class_80)class_77.method_411((class_1935)class_1802.field_8288).method_437(1))));
    }

    public static class_52.class_53 buildVillageLootTable(class_2960 house, Set<VillageLoot> villageLootSet) {
        class_55.class_56 lootPool = class_55.method_347().method_351((class_79.class_80)class_83.method_428((class_2960)house).method_437(3));
        for (VillageLoot loot : villageLootSet) {
            lootPool.method_351((class_79.class_80)class_83.method_428((class_2960)loot.lootTable));
        }
        return class_52.method_324().method_336(lootPool);
    }

    @NotNull
    public static class_52.class_53 buildShipwreckLootTable() {
        return class_52.method_324().method_336(class_55.method_347().method_351((class_79.class_80)class_83.method_428((class_2960)class_39.field_841)).method_351((class_79.class_80)class_83.method_428((class_2960)class_39.field_880)).method_351((class_79.class_80)class_83.method_428((class_2960)class_39.field_665)));
    }

    @NotNull
    public static class_52.class_53 buildDelegateLootTable(class_2960 reference) {
        return class_52.method_324().method_336(class_55.method_347().method_351((class_79.class_80)class_83.method_428((class_2960)reference)));
    }

    @NotNull
    public static class_52.class_53 buildOceanRuinLootTable(class_2960 archaeology) {
        return class_52.method_324().method_336(class_55.method_347().method_351((class_79.class_80)class_83.method_428((class_2960)class_39.field_300)).method_351((class_79.class_80)class_83.method_428((class_2960)class_39.field_397).method_437(8)).method_351((class_79.class_80)class_83.method_428((class_2960)archaeology)));
    }

    @NotNull
    public String method_10321() {
        return "Structure-specific loot tables for the Loonium";
    }

    public static enum VillageLoot {
        WEAPONSMITH(class_39.field_434),
        TOOLSMITH(class_39.field_17107),
        ARMORER(class_39.field_17009),
        CARTOGRAPHER(class_39.field_16751),
        MASON(class_39.field_17010),
        SHEPHERD(class_39.field_17011),
        BUTCHER(class_39.field_17012),
        FLETCHER(class_39.field_17108),
        FISHER(class_39.field_18007),
        TANNERY(class_39.field_16750),
        TEMPLE(class_39.field_17109);

        public final class_2960 lootTable;

        private VillageLoot(class_2960 lootTable) {
            this.lootTable = lootTable;
        }
    }
}

