/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item;

import vazkii.botania.api.item.ManaDissolvable;
import vazkii.botania.api.mana.ManaPool;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.EntityHelper;
import vazkii.botania.network.EffectType;
import vazkii.botania.network.clientbound.BotaniaEffectPacket;
import vazkii.botania.xplat.XplatAbstractions;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;

public class BlackLotusItem extends class_1792 implements ManaDissolvable {

	private static final int MANA_PER = 8000;
	private static final int MANA_PER_T2 = 100000;

	public BlackLotusItem(class_1793 props) {
		super(props);
	}

	@Override
	public boolean method_7886(class_1799 stack) {
		return super.method_7886(stack) || stack.method_31574(BotaniaItems.blackerLotus);
	}

	@Override
	public void onDissolveTick(ManaPool pool, class_1542 item) {
		if (pool.isFull() || pool.getCurrentMana() == 0) {
			return;
		}

		class_2338 pos = pool.getManaReceiverPos();
		boolean t2 = item.method_6983().method_31574(BotaniaItems.blackerLotus);

		if (!item.method_37908().field_9236) {
			pool.receiveMana(t2 ? MANA_PER_T2 : MANA_PER);
			EntityHelper.shrinkItem(item);
			XplatAbstractions.INSTANCE.sendToTracking(item, new BotaniaEffectPacket(EffectType.BLACK_LOTUS_DISSOLVE, pos.method_10263(), pos.method_10264() + 0.5, pos.method_10260()));
		}

		item.method_5783(BotaniaSounds.blackLotus, 1F, t2 ? 0.1F : 1F);
	}

	@Override
	public void method_7851(class_1799 stack, class_1937 world, List<class_2561> list, class_1836 flags) {
		list.add(class_2561.method_43471("botaniamisc.lotusDesc").method_27692(class_124.field_1080));
	}

}
