/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.crafting;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.recipe.StateIngredient;

import java.util.*;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2248;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_4970;
import net.minecraft.class_5819;

public class CompoundStateIngredient implements StateIngredient {
	protected final ImmutableSet<StateIngredient> ingredients;

	protected final Set<class_2680> resolvedBlocks;

	public CompoundStateIngredient(Collection<StateIngredient> ingredients) {
		this.ingredients = ImmutableSet.copyOf(ingredients);
		this.resolvedBlocks = new HashSet<>();
	}

	@Override
	public boolean test(class_2680 state) {
		for (var sub : this.ingredients) {
			if (sub.test(state)) {
				return true;
			}
		}
		return false;
	}

	@Override
	public class_2680 pick(class_5819 random) {
		return new ArrayList<>(getBlocks()).get(random.method_43048(getBlocks().size()));
	}

	@Override
	public JsonObject serialize() {
		JsonObject object = new JsonObject();
		object.addProperty("type", "compound");
		JsonArray array = new JsonArray();
		for (StateIngredient ingredient : ingredients) {
			array.add(ingredient.serialize());
		}
		object.add("ingredients", array);
		return object;
	}

	@Override
	public void write(class_2540 buffer) {
		ImmutableList<StateIngredient> ingredients = this.ingredients.asList();
		buffer.method_10804(3);
		buffer.method_10804(ingredients.size());
		for (StateIngredient ingredient : ingredients) {
			ingredient.write(buffer);
		}
	}

	@Override
	public List<class_1799> getDisplayedStacks() {
		return getBlocks().stream()
				.map(class_4970.class_4971::method_26204)
				.filter(b -> b.method_8389() != class_1802.field_8162)
				.map(class_1799::new)
				.collect(Collectors.toList());
	}

	@Override
	public List<class_2680> getDisplayed() {
		return new ArrayList<>(getBlocks());
	}

	@NotNull
	protected Set<class_2680> getBlocks() {
		if (this.resolvedBlocks.isEmpty()) {
			for (StateIngredient ingredient : this.ingredients) {
				if (ingredient instanceof BlockStateIngredient stateIngredient) {
					this.resolvedBlocks.add(stateIngredient.getBlock().method_9564());
				} else if (ingredient instanceof BlockStateStateIngredient stateIngredient) {
					this.resolvedBlocks.add(stateIngredient.getState());
				} else if (ingredient instanceof BlocksStateIngredient stateIngredient) {
					for (var block : stateIngredient.getBlocks()) {
						this.resolvedBlocks.add(block.method_9564());
					}
				}
			}
		}
		return resolvedBlocks;
	}

	public ImmutableSet<StateIngredient> getIngredients() {
		return ingredients;
	}

	@Override
	public String toString() {
		return "CompoundStateIngredient{" + getIngredients() + "}";
	}

	@Override
	public boolean equals(Object o) {
		if (this == o) {
			return true;
		}
		if (o == null || getClass() != o.getClass()) {
			return false;
		}

		CompoundStateIngredient that = (CompoundStateIngredient) o;

		return Objects.equals(ingredients, that.ingredients);
	}

	@Override
	public int hashCode() {
		return ingredients != null ? ingredients.hashCode() : 0;
	}
}
