/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.brew;

import vazkii.botania.common.brew.effect.*;
import vazkii.botania.common.lib.LibPotionNames;

import java.util.function.BiConsumer;
import net.minecraft.class_1291;
import net.minecraft.class_2960;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class BotaniaMobEffects {

	public static final class_1291 soulCross = new SoulCrossMobEffect();
	public static final class_1291 featherfeet = new FeatherfeetMobEffect();
	public static final class_1291 emptiness = new EmptinessMobEffect();
	public static final class_1291 bloodthrst = new BloodthirstMobEffect();
	public static final class_1291 allure = new AllureMobEffect();
	public static final class_1291 clear = new AbsolutionMobEffect();

	public static void registerPotions(BiConsumer<class_1291, class_2960> r) {
		r.accept(soulCross, prefix(LibPotionNames.SOUL_CROSS));
		r.accept(featherfeet, prefix(LibPotionNames.FEATHER_FEET));
		r.accept(emptiness, prefix(LibPotionNames.EMPTINESS));
		r.accept(bloodthrst, prefix(LibPotionNames.BLOODTHIRST));
		r.accept(allure, prefix(LibPotionNames.ALLURE));
		r.accept(clear, prefix(LibPotionNames.CLEAR));
	}
}
