/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.render.block_entity;

import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.mana.PoolOverlayProvider;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.block.block_entity.mana.ManaPoolBlockEntity;
import vazkii.botania.common.block.mana.ManaPoolBlock;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.common.helper.VecHelper;

import java.util.Objects;
import java.util.Random;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1723;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4696;
import net.minecraft.class_5614;
import net.minecraft.class_776;
import net.minecraft.class_827;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class ManaPoolBlockEntityRenderer implements class_827<ManaPoolBlockEntity> {

	// Overrides for when we call this renderer from a cart
	public static int cartMana = -1;
	private final class_1058 waterSprite;
	private final class_776 blockRenderDispatcher;

	public ManaPoolBlockEntityRenderer(class_5614.class_5615 ctx) {
		this.blockRenderDispatcher = ctx.method_32141();
		this.waterSprite = Objects.requireNonNull(
				class_310.method_1551().method_1549(class_1723.field_21668)
						.apply(prefix("block/mana_water"))
		);
	}

	@Override
	public void render(@Nullable ManaPoolBlockEntity pool, float f, class_4587 ms, class_4597 buffers, int light, int overlay) {
		ms.method_22903();

		boolean fab = pool != null && ((ManaPoolBlock) pool.method_11010().method_26204()).variant == ManaPoolBlock.Variant.FABULOUS;
		boolean diluted = pool != null && ((ManaPoolBlock) pool.method_11010().method_26204()).variant == ManaPoolBlock.Variant.DILUTED;
		boolean creative = pool != null && ((ManaPoolBlock) pool.method_11010().method_26204()).variant == ManaPoolBlock.Variant.CREATIVE;

		int insideUVStart = diluted ? 1 : 2;
		int insideUVEnd = 16 - insideUVStart;
		float poolBottom = insideUVStart / 16F + 0.001F;
		float poolTop = (diluted ? 5 : creative ? 9 : 7) / 16F;

		if (fab) {
			float time = ClientTickHandler.ticksInGame + ClientTickHandler.partialTicks;
			time += new Random(pool.method_11016().method_10263() ^ pool.method_11016().method_10264() ^ pool.method_11016().method_10260()).nextInt(100000);
			time *= 0.005F;
			int poolColor = pool.getColor().map(ColorHelper::getColorValue).orElse(-1);
			int color = vazkii.botania.common.helper.MathHelper.multiplyColor(class_3532.method_15369(class_3532.method_22450(time), 0.6F, 1F), poolColor);

			int red = (color & 0xFF0000) >> 16;
			int green = (color & 0xFF00) >> 8;
			int blue = color & 0xFF;
			class_2680 state = pool.method_11010();
			class_1087 model = blockRenderDispatcher.method_3349(state);
			class_4588 buffer = buffers.getBuffer(class_4696.method_23683(state, false));
			blockRenderDispatcher.method_3350()
					.method_3367(ms.method_23760(), buffer, state, model, red / 255F, green / 255F, blue / 255F, light, overlay);
		}

		if (pool != null) {
			class_2248 below = pool.method_10997().method_8320(pool.method_11016().method_10074()).method_26204();
			if (below instanceof PoolOverlayProvider overlayProvider) {
				var overlaySpriteId = overlayProvider.getIcon(pool.method_10997(), pool.method_11016());
				var overlayIcon = class_310.method_1551().method_1549(class_1723.field_21668).apply(overlaySpriteId);
				ms.method_22903();

				float alpha = (float) ((Math.sin((ClientTickHandler.ticksInGame + f) / 20.0) + 1) * 0.3 + 0.2);

				ms.method_46416(0, poolBottom, 0);
				ms.method_22907(VecHelper.rotateX(90F));

				class_4588 buffer = buffers.getBuffer(RenderHelper.ICON_OVERLAY);
				RenderHelper.renderIconCropped(
						ms, buffer,
						insideUVStart, insideUVStart, insideUVEnd, insideUVEnd,
						overlayIcon, 0xFFFFFF, alpha, light
				);

				ms.method_22909();
			}
		}

		int mana = pool == null ? cartMana : pool.getCurrentMana();
		int maxMana = pool == null ? -1 : pool.getMaxMana();
		if (maxMana == -1) {
			maxMana = ManaPoolBlockEntity.MAX_MANA;
		}

		float manaLevel = (float) mana / (float) maxMana;
		if (manaLevel > 0) {
			ms.method_22903();
			ms.method_46416(0, class_3532.method_37958(manaLevel, 0, 1, poolBottom, poolTop), 0);
			ms.method_22907(VecHelper.rotateX(90F));

			class_4588 buffer = buffers.getBuffer(RenderHelper.MANA_POOL_WATER);
			RenderHelper.renderIconCropped(
					ms, buffer,
					insideUVStart, insideUVStart, insideUVEnd, insideUVEnd,
					this.waterSprite, 0xFFFFFF, 1, light);

			ms.method_22909();
		}
		ms.method_22909();

		cartMana = -1;
	}

}
