package vazkii.botania.client.patchouli.processor;

import vazkii.botania.api.recipe.RecipeWithReagent;
import vazkii.botania.client.patchouli.PatchouliUtils;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

import java.util.List;
import net.minecraft.class_1937;

public abstract class ReagentRecipeProcessor implements IComponentProcessor {
	protected RecipeWithReagent recipe;

	@Override
	public abstract void setup(class_1937 level, IVariableProvider variables);

	@Override
	public IVariable process(class_1937 level, String key) {
		if (recipe == null) {
			return null;
		}
		return switch (key) {
			case "recipe" -> IVariable.wrap(recipe.method_8114().toString());
			case "reagent" -> PatchouliUtils.interweaveIngredients(List.of(recipe.getReagent()));
			case "output" -> IVariable.from(recipe.method_8110(level.method_30349()));
			case "heading" -> IVariable.from(recipe.method_8110(level.method_30349()).method_7964());
			default -> null;
		};
	}
}
