/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.block;

import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2582;
import net.minecraft.class_6862;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.common.handler.ContributorList;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.ItemWithBannerPattern;
import vazkii.botania.common.lib.BotaniaTags;

public class TinyPotatoBlockItem
extends class_1747
implements ItemWithBannerPattern {
    private static final Pattern TYPOS = Pattern.compile("(?!^vazkii$)^v[ao]{1,2}[sz]{0,2}[ak]{1,2}(i){1,2}l{0,2}$", 2);
    private static final List<String> ENCHANTMENT_NAMES = List.of("enchanted", "glowy", "shiny", "gay");
    private static final int NOT_MY_NAME = 17;
    private static final String TAG_TICKS = "notMyNameTicks";

    public TinyPotatoBlockItem(class_2248 block, class_1792.class_1793 props) {
        super(block, props);
    }

    @Override
    public class_6862<class_2582> getBannerPattern() {
        return BotaniaTags.BannerPatterns.PATTERN_ITEM_TINY_POTATO;
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 e, int t, boolean idunno) {
        if (!world.field_9236 && e instanceof class_1657) {
            int ticks;
            class_1657 player = (class_1657)e;
            if (e.field_6012 % 30 == 0 && TYPOS.matcher(stack.method_7964().getString()).matches() && (ticks = ItemNBTHelper.getInt(stack, TAG_TICKS, 0)) < 17) {
                player.method_43496((class_2561)class_2561.method_43471((String)("botania.tater.you_came_to_the_wrong_neighborhood." + ticks)).method_27692(class_124.field_1061));
                ItemNBTHelper.setInt(stack, TAG_TICKS, ticks + 1);
            }
        }
    }

    public static boolean isEnchantedName(@NotNull class_2561 name, @Nullable StringBuilder nameBuilder) {
        String trimmed = name.getString().trim();
        String nameString = trimmed.toLowerCase(Locale.ROOT);
        for (String prefix : ENCHANTMENT_NAMES) {
            if (!nameString.equals(prefix) && !nameString.startsWith(prefix + " ")) continue;
            if (nameBuilder != null) {
                if (trimmed.length() > prefix.length()) {
                    nameBuilder.append(trimmed, prefix.length() + 1, trimmed.length());
                } else {
                    nameBuilder.append(trimmed);
                }
            }
            return true;
        }
        if (nameBuilder != null) {
            nameBuilder.append(trimmed);
        }
        return false;
    }

    public static String removeFromFront(String name, String match) {
        return name.substring(match.length()).trim();
    }

    public boolean method_7886(@NotNull class_1799 stack) {
        return super.method_7886(stack) || TinyPotatoBlockItem.isEnchantedName(stack.method_7964(), null);
    }

    public class_1304 getEquipmentSlot(class_1799 stack) {
        return class_1304.field_6169;
    }

    public boolean canEquip(class_1799 stack, class_1304 armorType, class_1297 entity) {
        class_1657 player;
        return armorType == this.getEquipmentSlot(stack) && entity instanceof class_1657 && ContributorList.hasFlower((player = (class_1657)entity).method_7334().getName().toLowerCase(Locale.ROOT));
    }
}

