/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.bauble;

import com.google.common.base.Predicates;
import org.apache.commons.lang3.mutable.MutableFloat;

import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.client.lib.ResourcesLib;
import vazkii.botania.common.handler.BotaniaSounds;

import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_238;
import net.minecraft.class_2960;
import net.minecraft.class_3419;
import net.minecraft.class_8103;

public class CloakOfSinItem extends CloakOfVirtueItem {

	private static final class_2960 texture = new class_2960(ResourcesLib.MODEL_UNHOLY_CLOAK);
	private static final class_2960 textureGlow = new class_2960(ResourcesLib.MODEL_UNHOLY_CLOAK_GLOW);

	public CloakOfSinItem(class_1793 props) {
		super(props);
	}

	@Override
	protected boolean effectOnDamage(class_1282 src, MutableFloat amount, class_1657 player, class_1799 stack) {
		if (!src.method_48789(class_8103.field_42241)) {
			int range = 6;
			@SuppressWarnings("unchecked")
			List<class_1569> mobs = (List<class_1569>) (List<?>) player.method_37908().method_8390(class_1297.class, new class_238(player.method_23317() - range, player.method_23318() - range, player.method_23321() - range, player.method_23317() + range, player.method_23318() + range, player.method_23321() + range), Predicates.instanceOf(class_1569.class));
			for (class_1569 mob : mobs) {
				if (mob instanceof class_1309 entity) {
					entity.method_5643(player.method_48923().method_48802(player), amount.getValue());
				}
			}

			player.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), BotaniaSounds.unholyCloak, class_3419.field_15248, 1F, 1F);
			for (int i = 0; i < 90; i++) {
				float rad = i * 4F * (float) Math.PI / 180F;
				float xMotion = (float) Math.cos(rad) * 0.2F;
				float zMotion = (float) Math.sin(rad) * 0.2F;
				WispParticleData data = WispParticleData.wisp(0.6F + (float) Math.random() * 0.2F, 0.4F + (float) Math.random() + 0.25F, 0F, 0F);
				player.method_37908().method_8406(data, player.method_23317(), player.method_23318() + 0.5, player.method_23321(), xMotion, 0F, zMotion);
			}

			return true;
		}

		return false;
	}

	@Override
	class_2960 getCloakTexture() {
		return texture;
	}

	@Override
	class_2960 getCloakGlowTexture() {
		return textureGlow;
	}

}
