/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.armor.manaweave;

import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.item.ManaProficiencyArmor;
import vazkii.botania.api.mana.ManaDiscountArmor;

public class ManaweaveHelmItem extends ManaweaveArmorItem implements ManaDiscountArmor, ManaProficiencyArmor {

	public ManaweaveHelmItem(class_1793 props) {
		super(class_8051.field_41934, props);
	}

	@Override
	public float getDiscount(class_1799 stack, int slot, class_1657 player, @Nullable class_1799 tool) {
		return hasArmorSet(player) ? 0.4F : 0F;
	}

	@Override
	public boolean shouldGiveProficiency(class_1799 stack, class_1304 slot, class_1657 player, class_1799 rod) {
		return hasArmorSet(player);
	}

	@Override
	protected int getManaPerDamage() {
		return 30;
	}
}
