/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item;

import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1707;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_3417;
import net.minecraft.class_747;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.item.BlockProvider;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.item.rod.ShiftingCrustRodItem;
import vazkii.botania.xplat.BotaniaConfig;

public class EnderHandItem extends class_1792 {

	private static final int COST_PROVIDE = 5;
	private static final int COST_SELF = 250;
	private static final int COST_OTHER = 5000;

	public EnderHandItem(class_1793 props) {
		super(props);
	}

	@NotNull
	@Override
	public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, @NotNull class_1268 hand) {
		class_1799 stack = player.method_5998(hand);
		if (ManaItemHandler.instance().requestManaExact(stack, player, COST_SELF, false)) {
			if (!player.method_37908().field_9236) {
				player.method_17355(new class_747((windowId, playerInv, p) -> {
					return class_1707.method_19245(windowId, playerInv, p.method_7274());
				}, stack.method_7964()));
				ManaItemHandler.instance().requestManaExact(stack, player, COST_SELF, true);
			}
			player.method_5783(class_3417.field_14952, 1F, 1F);
			return class_1271.method_29237(stack, world.method_8608());
		}
		return class_1271.method_22430(stack);
	}

	@Override
	public class_1269 method_7847(class_1799 stack, class_1657 player, class_1309 entity, class_1268 hand) {
		if (entity.method_5805() && BotaniaConfig.common().enderPickpocketEnabled() && entity instanceof class_1657 other && ManaItemHandler.instance().requestManaExact(stack, player, COST_OTHER, false)) {
			if (!player.method_37908().field_9236) {
				player.method_17355(new class_747((windowId, playerInv, p) -> class_1707.method_19245(windowId, playerInv, other.method_7274()), stack.method_7964()));
				ManaItemHandler.instance().requestManaExact(stack, player, COST_OTHER, true);
			}
			player.method_5783(class_3417.field_14952, 1F, 1F);
			return class_1269.method_29236(player.method_37908().method_8608());
		}

		return class_1269.field_5811;
	}

	public static class BlockProviderImpl implements BlockProvider {
		private final class_1799 stack;

		public BlockProviderImpl(class_1799 stack) {
			this.stack = stack;
		}

		@Override
		public boolean provideBlock(class_1657 player, class_1799 requestor, class_2248 block, boolean doit) {
			if (!requestor.method_7960() && requestor.method_31574(stack.method_7909())) {
				return false;
			}

			class_1799 istack = ShiftingCrustRodItem.removeFromInventory(player, player.method_7274(), stack, block.method_8389(), false);
			if (!istack.method_7960()) {
				boolean mana = ManaItemHandler.instance().requestManaExact(stack, player, COST_PROVIDE, false);
				if (mana) {
					if (doit) {
						ManaItemHandler.instance().requestManaExact(stack, player, COST_PROVIDE, true);
						ShiftingCrustRodItem.removeFromInventory(player, player.method_7274(), stack, block.method_8389(), true);
					}

					return true;
				}
			}

			return false;
		}

		@Override
		public int getBlockCount(class_1657 player, class_1799 requestor, class_2248 block) {
			if (!requestor.method_7960() && requestor.method_31574(stack.method_7909())) {
				return 0;
			}

			return ShiftingCrustRodItem.getInventoryItemCount(player, player.method_7274(), stack, block.method_8389());
		}
	}

}
