/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.mana.ManaCollisionGhost;
import vazkii.botania.common.block.block_entity.PlatformBlockEntity;
import vazkii.botania.common.lib.BotaniaTags;

import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3726;
import net.minecraft.class_3727;
import net.minecraft.class_3965;

public class PlatformBlock extends BotaniaBlock implements ManaCollisionGhost, class_2343 {

	public enum Variant {
		ABSTRUSE(false, (pos, context) -> {
			if (context instanceof class_3727 econtext) {
				class_1297 e = econtext.method_32480();
				return (e == null || e.method_23318() > pos.method_10264() + 0.9 && !context.method_16193());
			} else {
				return true;
			}
		}),
		SPECTRAL(false, (pos, context) -> false),
		INFRANGIBLE(true, (pos, context) -> true);

		public final boolean indestructible;
		public final BiPredicate<class_2338, class_3726> collide;

		Variant(boolean i, BiPredicate<class_2338, class_3726> p) {
			indestructible = i;
			collide = p;
		}
	}

	private final Variant variant;

	public PlatformBlock(@NotNull Variant v, class_2251 builder) {
		super(builder);
		this.variant = v;
	}

	public Variant getVariant() {
		return variant;
	}

	@NotNull
	@Override
	public class_265 method_9530(@NotNull class_2680 state, @NotNull class_1922 world, @NotNull class_2338 pos, @NotNull class_3726 context) {
		class_2586 te = world.method_8321(pos);
		if (te instanceof PlatformBlockEntity platform && platform.getCamoState() != null) {
			return platform.getCamoState().method_26218(world, pos);
		} else {
			return super.method_9530(state, world, pos, context);
		}
	}

	@NotNull
	@Override
	public class_265 method_9549(@NotNull class_2680 state, @NotNull class_1922 world, @NotNull class_2338 pos, class_3726 context) {
		if (variant.collide.test(pos, context)) {
			// NB: Use full shape from super.getOutlineShape instead of camo state. May change later.
			return super.method_9530(state, world, pos, context);
		} else {
			return class_259.method_1073();
		}
	}

	@NotNull
	@Override
	public class_265 method_25959(@NotNull class_2680 state, @NotNull class_1922 level, @NotNull class_2338 pos) {
		// Vanilla defaults support shape to collision shape, but spectral platforms don't collide,
		// so set this by hand.
		return class_259.method_1077();
	}

	@Override
	public float method_9575(class_2680 state, class_1922 level, class_2338 pos) {
		return 1.0F;
	}

	@NotNull
	@Override
	public class_2586 method_10123(@NotNull class_2338 pos, @NotNull class_2680 state) {
		return new PlatformBlockEntity(pos, state);
	}

	@Override
	public Behaviour getGhostBehaviour() {
		return Behaviour.SKIP_ALL;
	}

	@Override
	public void method_9568(class_1799 stack, @Nullable class_1922 worldIn, List<class_2561> tooltip, class_1836 flagIn) {
		if (variant.indestructible) {
			tooltip.add(class_2561.method_43471("botaniamisc.creative").method_27692(class_124.field_1080));
		}
	}

	@NotNull
	@Override
	public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
		class_2586 tile = world.method_8321(pos);
		class_1799 currentStack = player.method_5998(hand);

		if (variant.indestructible && !player.method_7337()) {
			return class_1269.field_5811;
		}
		if (!currentStack.method_7960()
				&& class_2248.method_9503(currentStack.method_7909()) != class_2246.field_10124
				&& tile instanceof PlatformBlockEntity camo) {
			class_1750 ctx = new class_1750(player, hand, currentStack, hit);
			class_2680 changeState = class_2248.method_9503(currentStack.method_7909()).method_9605(ctx);

			if (changeState != null && !changeState.method_26164(BotaniaTags.Blocks.UNSUPPORTED_PLATFORM_DISGUISE)
					&& (changeState.method_26216(world, pos) || changeState.method_26217() == class_2464.field_11458)
					&& !(changeState.method_26204() instanceof PlatformBlock)
					&& !changeState.method_26215()) {
				if (!world.field_9236) {
					camo.setCamoState(changeState);
				}

				return class_1269.method_29236(world.method_8608());
			}
		}

		return class_1269.field_5811;
	}

}
