/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.gui.box;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_465;
import net.minecraft.class_490;
import vazkii.botania.client.lib.ResourcesLib;

public class BaubleBoxGui extends class_465<BaubleBoxContainer> {

	private static final class_2960 texture = new class_2960(ResourcesLib.GUI_BAUBLE_BOX);
	private int mouseX;
	private int mouseY;

	public BaubleBoxGui(BaubleBoxContainer container, class_1661 player, class_2561 title) {
		super(container, player, title);
	}

	@Override
	public void method_25394(class_332 gui, int mouseX, int mouseY, float partialTicks) {
		this.method_25420(gui);
		super.method_25394(gui, mouseX, mouseY, partialTicks);
		this.mouseX = mouseX;
		this.mouseY = mouseY;
		this.method_2380(gui, mouseX, mouseY);
	}

	@Override
	protected void method_2388(class_332 gui, int x, int y) {
		// No-op, there's no space for gui titles
	}

	@Override
	protected void method_2389(class_332 gui, float partialTicks, int mouseX, int mouseY) {
		RenderSystem.setShaderColor(1.0F, 1.0F, 1.0F, 1.0F);
		gui.method_25302(texture, field_2776, field_2800, 0, 0, field_2792, field_2779);
		class_490.method_2486(gui, field_2776 + 31, field_2800 + 75, 30, field_2776 + 31 - this.mouseX, field_2800 + 75 - 50 - this.mouseY, field_22787.field_1724);
	}

}
