/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.mixin.client;

import net.minecraft.class_1937;
import net.minecraft.class_291;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4599;
import net.minecraft.class_638;
import net.minecraft.class_757;
import net.minecraft.class_761;
import net.minecraft.class_765;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.*;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import vazkii.botania.client.core.SkyblockWorldInfo;
import vazkii.botania.client.render.world.SkyblockSkyRenderer;
import vazkii.botania.client.render.world.WorldOverlays;
import vazkii.botania.xplat.BotaniaConfig;

/**
 * This Mixin implements the Garden of Glass skybox and some in-world overlays.
 * It needs to be applied before similar mixins from other mods (e.g. Enhanced Celestials, BedrockIfy) to prevent those
 * from removing our injection points. These changes are compatible with those mods, assuming proper sequencing.
 */
@Mixin(value = class_761.class, priority = 900)
public class LevelRendererMixin {
	@Shadow
	@Nullable
	private class_291 starBuffer;

	@Shadow
	@Final
	private class_4599 renderBuffers;
	@Shadow
	@Nullable
	private class_638 level;
	@Unique
	private static final Matrix4f SUN_SCALE = new Matrix4f().scale(2F, 1F, 2F);

	@Unique
	private static final Matrix4f MOON_SCALE = new Matrix4f().scale(1.5F, 1F, 1.5F);

	@Unique
	private static boolean isGogSky() {
		class_1937 world = class_310.method_1551().field_1687;
		boolean isGog = world.method_8401() instanceof SkyblockWorldInfo skyblockInfo && skyblockInfo.isGardenOfGlass();
		return BotaniaConfig.client().enableFancySkybox()
				&& world.method_27983() == class_1937.field_25179
				&& (BotaniaConfig.client().enableFancySkyboxInNormalWorlds() || isGog);
	}

	/**
	 * Render planets and other extras, after the first invoke to ms.rotate(Y) after getRainLevel is called
	 */
	@Inject(
		method = "renderSky",
		slice = @Slice(
			from = @At(
				ordinal = 0, value = "INVOKE",
				target = "Lnet/minecraft/client/multiplayer/ClientLevel;getRainLevel(F)F"
			)
		),
		at = @At(
			shift = At.Shift.AFTER,
			ordinal = 0,
			value = "INVOKE",
			target = "Lcom/mojang/blaze3d/vertex/PoseStack;mulPose(Lorg/joml/Quaternionf;)V"
		),
		require = 0
	)
	private void renderExtras(class_4587 ms, Matrix4f projMat, float partialTicks, class_4184 camera,
			boolean foggy, Runnable resetFog, CallbackInfo ci) {
		if (isGogSky()) {
			SkyblockSkyRenderer.renderExtra(ms, class_310.method_1551().field_1687, partialTicks, 0);
		}
	}

	/**
	 * Make the sun bigger by scaling it to double size
	 */
	@ModifyVariable(
		method = "renderSky",
		slice = @Slice(
			from = @At(ordinal = 1, value = "INVOKE", target = "Lnet/minecraft/client/multiplayer/ClientLevel;getTimeOfDay(F)F"),
			to = @At(ordinal = 0, value = "INVOKE", target = "Lcom/mojang/blaze3d/systems/RenderSystem;setShaderTexture(ILnet/minecraft/resources/ResourceLocation;)V")
		),
		at = @At(value = "CONSTANT", args = "floatValue=30.0"),
		ordinal = 1,
		require = 0
	)
	private Matrix4f makeSunBigger(Matrix4f matrix) {
		if (isGogSky()) {
			// copies the matrix
			matrix = new Matrix4f(matrix);
			matrix.mul(SUN_SCALE);
		}
		return matrix;
	}

	/**
	 * Make the moon bigger by scaling it to triple size (the matrix is already scaled on the call above)
	 */
	@ModifyVariable(
		method = "renderSky",
		slice = @Slice(
			from = @At(ordinal = 0, value = "INVOKE", target = "Lcom/mojang/blaze3d/systems/RenderSystem;setShaderTexture(ILnet/minecraft/resources/ResourceLocation;)V"),
			to = @At(ordinal = 1, value = "INVOKE", target = "Lcom/mojang/blaze3d/systems/RenderSystem;setShaderTexture(ILnet/minecraft/resources/ResourceLocation;)V")
		),
		at = @At(value = "CONSTANT", args = "floatValue=20.0"),
		ordinal = 1,
		require = 0
	)
	private Matrix4f makeMoonBigger(Matrix4f matrix) {
		if (isGogSky()) {
			matrix.mul(MOON_SCALE);
		}
		return matrix;
	}

	/**
	 * Render lots of extra stars
	 */
	@Inject(
		method = "renderSky",
		at = @At(value = "INVOKE", target = "Lnet/minecraft/client/multiplayer/ClientLevel;getStarBrightness(F)F"),
		require = 0
	)
	private void renderExtraStars(class_4587 ms, Matrix4f projMat, float partialTicks, class_4184 camera,
			boolean foggy, Runnable resetFog, CallbackInfo ci) {
		if (isGogSky()) {
			SkyblockSkyRenderer.renderStars(starBuffer, ms, projMat, partialTicks, resetFog);
		}
	}

	@SuppressWarnings("mapping") // applyModelViewMatrix is unobfuscated - not mapped on Fabric, mapped on Forge
	@Inject(
		method = "renderLevel",
		at = @At(
			shift = At.Shift.AFTER,
			value = "INVOKE",
			target = "Lcom/mojang/blaze3d/systems/RenderSystem;applyModelViewMatrix()V",
			ordinal = 0 // after debugRenderer, before a long sequence of endBatch calls
		)
	)
	private void renderOverlays(class_4587 ps, float partialTicks, long unknown, boolean drawBlockOutline,
			class_4184 camera, class_757 gameRenderer, class_765 lightTexture, Matrix4f projMat, CallbackInfo ci) {
		// Called from our own mixin instead of e.g. Forge's render world last event,
		// because that event is too late for Fabulous mode
		WorldOverlays.renderWorldLast(camera, partialTicks, ps, renderBuffers, level);
	}
}
