/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.bauble;

import ;
import J;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.client.core.handler.MiscellaneousModels;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.client.render.AccessoryRenderRegistry;
import vazkii.botania.client.render.AccessoryRenderer;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.proxy.Proxy;
import vazkii.botania.mixin.AbstractHorseAccessor;
import vazkii.botania.mixin.RandomizableContainerBlockEntityAccessor;

import java.util.List;
import net.minecraft.class_1087;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1492;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1693;
import net.minecraft.class_1799;
import net.minecraft.class_1914;
import net.minecraft.class_1915;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2501;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_572;
import net.minecraft.class_7298;

public class SpectatorItem extends BaubleItem {
	private static final int[] EMPTY_ENTITIES_ARRAY = new int[0];
	private static final long[] EMPTY_BLOCKPOS_ARRAY = new long[0];
	public static final String TAG_ENTITY_POSITIONS = "highlightPositionsEnt";
	public static final String TAG_BLOCK_POSITIONS = "highlightPositionsBlock";
	public static final int RANGE_ENTITIES = 24;
	public static final int RANGE_BLOCKS = 12;
	public static final int SCAN_INTERVAL_TICKS = 4;

	public SpectatorItem(class_1793 props) {
		super(props);
		Proxy.INSTANCE.runOnClient(() -> () -> AccessoryRenderRegistry.register(this, new Renderer()));
	}

	@Override
	public void onWornTick(class_1799 stack, class_1309 living) {
		if (!(living instanceof class_1657 player)) {
			return;
		}

		if (living.method_37908().field_9236) {
			this.showScanResults(stack, player);
		} else if (living.field_6012 % SCAN_INTERVAL_TICKS == 0) {
			this.scanForItems(stack, player);
		}
	}

	@Override
	public void onUnequipped(class_1799 stack, class_1309 entity) {
		ItemNBTHelper.removeEntry(stack, TAG_BLOCK_POSITIONS);
		ItemNBTHelper.removeEntry(stack, TAG_ENTITY_POSITIONS);
	}

	public static class Renderer implements AccessoryRenderer {
		@Override
		public void doRender(class_572<?> bipedModel, class_1799 stack, class_1309 living, class_4587 ms, class_4597 buffers, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
			boolean armor = !living.method_6118(class_1304.field_6169).method_7960();
			bipedModel.field_3398.method_22703(ms);
			ms.method_22904(-0.35, -0.2, armor ? 0.05 : 0.1);
			ms.method_22905(0.75F, -0.75F, -0.75F);

			class_1087 model = MiscellaneousModels.INSTANCE.itemFinderGem;
			class_4588 buffer = buffers.getBuffer(class_4722.method_24074());
			class_310.method_1551().method_1541().method_3350()
					.method_3367(ms.method_23760(), buffer, null, model, 1, 1, 1, light, class_4608.field_21444);
		}
	}

	protected void showScanResults(class_1799 stack, class_1657 player) {
		if (player != Proxy.INSTANCE.getClientPlayer()) {
			return;
		}

		// backward compatibility: this was a list tag before
		var blockPosLongs = ItemNBTHelper.verifyType(stack, TAG_BLOCK_POSITIONS, class_2501.class)
				? ItemNBTHelper.getLongArray(stack, TAG_BLOCK_POSITIONS)
				: EMPTY_BLOCKPOS_ARRAY;

		for (var blockPosLong : blockPosLongs) {
			class_2338 pos = class_2338.method_10092(blockPosLong);
			float m = 0.02F;
			WispParticleData data = WispParticleData.wisp(0.15F + 0.05F * (float) Math.random(), (float) Math.random(), (float) Math.random(), (float) Math.random(), false);
			player.method_37908().method_8406(data, pos.method_10263() + (float) Math.random(), pos.method_10264() + (float) Math.random(), pos.method_10260() + (float) Math.random(), m * (float) (Math.random() - 0.5), m * (float) (Math.random() - 0.5), m * (float) (Math.random() - 0.5));
		}

		int[] entities = ItemNBTHelper.getIntArray(stack, TAG_ENTITY_POSITIONS);
		for (int i : entities) {
			class_1297 e = player.method_37908().method_8469(i);
			if (e != null && e.method_5805() && Math.random() < 0.6) {
				WispParticleData data = WispParticleData.wisp(0.15F + 0.05F * (float) Math.random(), (float) Math.random(), (float) Math.random(), (float) Math.random(), Math.random() < 0.6);
				player.method_37908().method_8406(data, e.method_23317() + (float) (Math.random() * 0.5 - 0.25) * 0.45F, e.method_23318() + e.method_17682(), e.method_23321() + (float) (Math.random() * 0.5 - 0.25) * 0.45F, 0, 0.05F + 0.03F * (float) Math.random(), 0);
			}
		}
	}

	public void scanForItems(class_1799 stack, class_1657 player) {
		class_1799 mainHandStack = player.method_6047();
		class_1799 offHandStack = player.method_6079();

		int[] entityIds = scanEntities(player, mainHandStack, offHandStack);
		ItemNBTHelper.setIntArray(stack, TAG_ENTITY_POSITIONS, entityIds);

		long[] blockPositionLongs = scanBlockContainers(player, mainHandStack, offHandStack);
		ItemNBTHelper.setLongArray(stack, TAG_BLOCK_POSITIONS, blockPositionLongs);
	}

	private int[] scanEntities(class_1657 player, class_1799 mainHandStack, class_1799 offHandStack) {
		boolean emptyHands = mainHandStack.method_7960() && offHandStack.method_7960();
		if (emptyHands && !player.method_5715()) {
			return EMPTY_ENTITIES_ARRAY;
		}
		var entityIds = new IntArrayList();
		List<class_1297> entities = player.method_37908().method_18467(class_1297.class, new class_238(player.method_24515()).method_1014(RANGE_ENTITIES));
		for (class_1297 e : entities) {
			if (e == player) {
				continue;
			}
			if (e instanceof class_1542 item) {
				class_1799 entityStack = item.method_6983();
				if (player.method_5715() || equalStacks(entityStack, mainHandStack, offHandStack)) {
					entityIds.add(item.method_5628());
				}
			} else if (emptyHands) {
				continue;
			}
			if (e instanceof class_1657 targetPlayer) {
				if (scanInventory(targetPlayer.method_31548(), mainHandStack, offHandStack)) {
					entityIds.add(targetPlayer.method_5628());
				} else {
					class_1263 baubleInventory = BotaniaAPI.instance().getAccessoriesInventory(targetPlayer);
					if (scanInventory(baubleInventory, mainHandStack, offHandStack)) {
						entityIds.add(targetPlayer.method_5628());
					}
				}
			} else if (e instanceof class_1492 horse && horse.method_6703()) {
				if (scanInventory(((AbstractHorseAccessor) horse).getInventory(), mainHandStack, offHandStack)) {
					entityIds.add(horse.method_5628());
				}
			} else if (e instanceof class_7298 allay && allay.method_43396()) {
				if (equalStacks(allay.method_6047(), mainHandStack, offHandStack)) {
					entityIds.add(allay.method_5628());
				}
			} else if (e instanceof class_1915 villager) {
				for (class_1914 offer : villager.method_8264()) {
					if (equalStacks(offer.method_8246(), mainHandStack, offHandStack)
							|| equalStacks(offer.method_8247(), mainHandStack, offHandStack)
							|| equalStacks(offer.method_8250(), mainHandStack, offHandStack)) {
						entityIds.add(e.method_5628());
					}
				}
			} else if (e instanceof class_1263 inv && (!(inv instanceof class_1693 minecart)
					|| minecart.method_42276() == null)) {
				if (scanInventory(inv, mainHandStack, offHandStack)) {
					entityIds.add(e.method_5628());
				}
			}
		}
		entityIds.trim();
		return entityIds.elements();
	}

	private long[] scanBlockContainers(class_1657 player, class_1799 mainHandStack, class_1799 offHandStack) {
		if (mainHandStack.method_7960() && offHandStack.method_7960()) {
			return EMPTY_BLOCKPOS_ARRAY;
		}
		var blockPositions = new LongArrayList();
		class_2338.method_29715(new class_238(player.method_24515()).method_1014(RANGE_BLOCKS))
				.filter(pos -> scanBlock(player, pos, mainHandStack, offHandStack))
				.forEach(pos -> blockPositions.add(pos.method_10063()));
		blockPositions.trim();
		return blockPositions.elements();
	}

	private boolean scanBlock(class_1657 player, class_2338 pos, class_1799 mainHandStack, class_1799 offHandStack) {
		class_1937 level = player.method_37908();
		if (!level.method_8477(pos) || !level.method_8320(pos).method_31709()) {
			return false;
		}
		class_2586 blockEntity = level.method_8321(pos);
		return blockEntity instanceof class_1263 inv && (!(blockEntity instanceof class_2621 lootInv)
				|| ((RandomizableContainerBlockEntityAccessor) lootInv).getLootTable() == null)
				&& scanInventory(inv, mainHandStack, offHandStack);
	}

	private boolean equalStacks(class_1799 testStack, class_1799 referenceStack1, class_1799 referenceStack2) {
		return !testStack.method_7960() && (class_1799.method_31577(testStack, referenceStack1)
				|| class_1799.method_31577(testStack, referenceStack2));
	}

	private boolean scanInventory(class_1263 inv, class_1799 mainHandStack, class_1799 offHandStack) {
		for (int l = 0; l < inv.method_5439(); l++) {
			class_1799 inventoryStack = inv.method_5438(l);
			// Some mods still set stuff to null apparently...
			if (inventoryStack != null && equalStacks(inventoryStack, mainHandStack, offHandStack)) {
				return true;
			}
		}
		return false;
	}

}
