/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.flower.generating;

import net.minecraft.class_2248;
import net.minecraft.class_2272;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5712;
import net.minecraft.class_6088;
import vazkii.botania.api.block_entity.GeneratingFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.block.BotaniaFlowerBlocks;

public class KekimurusBlockEntity extends GeneratingFlowerBlockEntity {
	private static final int RANGE = 5;

	public KekimurusBlockEntity(class_2338 pos, class_2680 state) {
		super(BotaniaFlowerBlocks.KEKIMURUS, pos, state);
	}

	@Override
	public void tickFlower() {
		super.tickFlower();

		if (method_10997().field_9236) {
			return;
		}

		int mana = 1800;

		if (getMaxMana() - this.getMana() >= mana && !method_10997().field_9236 && ticksExisted % 80 == 0) {
			for (int i = 0; i < RANGE * 2 + 1; i++) {
				for (int j = 0; j < RANGE * 2 + 1; j++) {
					for (int k = 0; k < RANGE * 2 + 1; k++) {
						class_2338 pos = getEffectivePos().method_10069(i - RANGE, j - RANGE, k - RANGE);
						class_2680 state = method_10997().method_8320(pos);
						class_2248 block = state.method_26204();
						if (block instanceof class_2272) {
							int nextSlicesEaten = state.method_11654(class_2272.field_10739) + 1;
							if (nextSlicesEaten > 6) {
								method_10997().method_8650(pos, false);
							} else {
								method_10997().method_8501(pos, state.method_11657(class_2272.field_10739, nextSlicesEaten));
							}

							method_10997().method_20290(class_6088.field_31144, pos, class_2248.method_9507(state));
							method_10997().method_33596(null, class_5712.field_28735, getEffectivePos());
							//Usage of vanilla sound event: Subtitle is "Eating", generic sounds are meant to be reused.
							method_10997().method_8396(null, getEffectivePos(), class_3417.field_20614, class_3419.field_15245, 1F, 0.5F + (float) Math.random() * 0.5F);
							addMana(mana);
							sync();
							return;
						}
					}
				}
			}
		}
	}

	@Override
	public RadiusDescriptor getRadius() {
		return RadiusDescriptor.Rectangle.square(getEffectivePos(), RANGE);
	}

	@Override
	public int getColor() {
		return 0x935D28;
	}

	@Override
	public int getMaxMana() {
		return 9001;
	}

}
