/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.render.block_entity;

import org.jetbrains.annotations.NotNull;

import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.block.block_entity.TerrestrialAgglomerationPlateBlockEntity;
import vazkii.botania.common.helper.VecHelper;

import java.util.Objects;
import net.minecraft.class_1058;
import net.minecraft.class_1723;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_827;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class TerrestrialAgglomerationPlateBlockEntityRenderer implements class_827<TerrestrialAgglomerationPlateBlockEntity> {
	private final class_1058 overlaySprite;

	public TerrestrialAgglomerationPlateBlockEntityRenderer(class_5614.class_5615 manager) {
		this.overlaySprite = Objects.requireNonNull(
				class_310.method_1551().method_1549(class_1723.field_21668)
						.apply(prefix("block/terra_plate_overlay"))
		);
	}

	@Override
	public void render(@NotNull TerrestrialAgglomerationPlateBlockEntity plate, float f, class_4587 ms, class_4597 buffers, int light, int overlay) {
		float alphaMod = Math.min(1.0F, plate.getCompletion() / 0.1F);

		ms.method_22903();
		ms.method_46416(0F, 3F / 16F + 0.001F, 0F);
		ms.method_22907(VecHelper.rotateX(90F));

		float alpha = (float) ((Math.sin((ClientTickHandler.ticksInGame + f) / 8D) + 1D) / 5D + 0.6D) * alphaMod;

		class_4588 buffer = buffers.getBuffer(RenderHelper.TERRA_PLATE);
		RenderHelper.renderIconFullBright(ms, buffer, this.overlaySprite, alpha);

		ms.method_22909();
	}

}
