/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.functional;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1074;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1429;
import net.minecraft.class_1438;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_3489;
import net.minecraft.class_3542;
import net.minecraft.class_7917;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block.Wandable;
import vazkii.botania.api.block_entity.BindableSpecialFlowerBlockEntity;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.helper.DelayHelper;
import vazkii.botania.common.helper.EntityHelper;
import vazkii.botania.mixin.AnimalAccessor;
import vazkii.botania.mixin.MushroomCowAccessor;

public class PollidisiacBlockEntity
extends FunctionalFlowerBlockEntity
implements Wandable {
    private static final String TAG_FEEDING_MODE = "mode";
    private static final int RANGE = 6;
    private static final int MANA_COST = 12;
    @NotNull
    private Mode mode = Mode.FEED_ADULTS;

    public PollidisiacBlockEntity(class_2338 pos, class_2680 state) {
        super(BotaniaFlowerBlocks.POLLIDISIAC, pos, state);
    }

    @Override
    public void tickFlower() {
        List<class_1542> items;
        super.tickFlower();
        if (!this.method_10997().field_9236 && this.getMana() >= 12 && !(items = this.getItems()).isEmpty()) {
            List<class_1429> animals = this.getAnimals();
            this.feedAnimal(animals, items);
        }
    }

    @NotNull
    private List<class_1542> getItems() {
        class_238 pickupBounds = new class_238(this.method_11016()).method_1014(6.0);
        return this.method_10997().method_8390(class_1542.class, pickupBounds, itemEntity -> DelayHelper.canInteractWith(this, itemEntity));
    }

    @NotNull
    private List<class_1429> getAnimals() {
        class_238 bounds = new class_238(this.getEffectivePos()).method_1014(6.0);
        return this.method_10997().method_8390(class_1429.class, bounds, (Predicate)this.mode);
    }

    private void feedAnimal(List<class_1429> animals, List<class_1542> items) {
        Collections.shuffle(animals);
        animals.sort(Comparator.comparing(class_1296::method_6109).thenComparingInt(animal -> Math.min(animal.method_5618(), 0)));
        for (class_1429 animal2 : animals) {
            if (animal2.method_5618() == 0 && !animal2.method_6479() || animal2.method_5618() < -600 && -animal2.method_5618() % 100 == 0) {
                for (class_1542 item : items) {
                    if (!animal2.method_6481(item.method_6983())) continue;
                    this.consumeFoodItemAndMana(item);
                    if (animal2.method_6109()) {
                        animal2.method_5620(class_1296.method_41321((int)(-animal2.method_5618())), true);
                    } else {
                        animal2.method_6476(1200);
                        ((AnimalAccessor)animal2).botania_setLoveCause(null);
                    }
                    this.method_10997().method_8421((class_1297)animal2, (byte)18);
                    break;
                }
                if (this.getMana() < 12) break;
            }
            if (animal2.method_6109() || !PollidisiacBlockEntity.isBrownMooshroomWithoutEffect(animal2)) continue;
            for (class_1542 item : items) {
                class_7917 effect;
                class_1799 stack = item.method_6983();
                if (!stack.method_31573(class_3489.field_15543) || (effect = class_7917.method_47380((class_1935)stack.method_7909())) == null) continue;
                this.consumeFoodItemAndMana(item);
                MushroomCowAccessor cowAccessor = (MushroomCowAccessor)animal2;
                cowAccessor.setEffect(effect.method_10188());
                cowAccessor.setEffectDuration(effect.method_10187());
                animal2.method_5783(class_3417.field_18267, 2.0f, 1.0f);
                break;
            }
            if (this.getMana() >= 12) continue;
            break;
        }
    }

    private void consumeFoodItemAndMana(class_1542 itemEntity) {
        EntityHelper.shrinkItem(itemEntity);
        this.addMana(-12);
    }

    private static boolean isBrownMooshroomWithoutEffect(class_1429 animal) {
        class_1438 mushroomCow;
        if (animal instanceof class_1438 && (mushroomCow = (class_1438)animal).method_47847() == class_1438.class_4053.field_18110) {
            MushroomCowAccessor cowAccessor = (MushroomCowAccessor)animal;
            return cowAccessor.getEffect() == null;
        }
        return false;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), 6);
    }

    @Override
    public RadiusDescriptor getSecondaryRadius() {
        return this.method_11016().equals((Object)this.getEffectivePos()) ? null : RadiusDescriptor.Rectangle.square(this.method_11016(), 6);
    }

    @Override
    public int getMaxMana() {
        return 120;
    }

    @Override
    public int getColor() {
        return 13584665;
    }

    @NotNull
    public Mode getMode() {
        return this.mode;
    }

    @Override
    public boolean onUsedByWand(@Nullable class_1657 player, class_1799 stack, class_2350 side) {
        if (player == null || player.method_5715()) {
            this.mode = this.mode.getNextMode();
            this.method_5431();
            this.sync();
            return true;
        }
        return false;
    }

    @Override
    public void readFromPacketNBT(class_2487 cmp) {
        super.readFromPacketNBT(cmp);
        this.mode = Mode.forName(cmp.method_10558(TAG_FEEDING_MODE));
    }

    @Override
    public void writeToPacketNBT(class_2487 cmp) {
        super.writeToPacketNBT(cmp);
        cmp.method_10582(TAG_FEEDING_MODE, this.mode.method_15434());
    }

    public static enum Mode implements class_3542,
    Predicate<class_1429>
    {
        FEED_ADULTS("feed_adults", Predicate.not(class_1296::method_6109)),
        FEED_BABIES("feed_babies", class_1296::method_6109),
        FEED_ALL("feed_all", animal -> true);

        private static final class_3542.class_7292<Mode> CODEC;
        @NotNull
        private final String name;
        @NotNull
        private final Predicate<class_1429> predicate;

        public static Mode forName(String name) {
            return (Mode)CODEC.method_47920(name, (Enum)FEED_ADULTS);
        }

        private Mode(String name, Predicate<class_1429> predicate) {
            this.name = name;
            this.predicate = predicate;
        }

        @Override
        public boolean test(class_1429 animal) {
            return this.predicate.test(animal);
        }

        @NotNull
        public String method_15434() {
            return this.name;
        }

        @NotNull
        public Mode getNextMode() {
            Mode[] modes = Mode.values();
            int nextMode = this.ordinal() + 1;
            return modes[nextMode % modes.length];
        }

        static {
            CODEC = class_3542.method_28140(Mode::values);
        }
    }

    public static class WandHud
    extends BindableSpecialFlowerBlockEntity.BindableFlowerWandHud<PollidisiacBlockEntity> {
        public WandHud(PollidisiacBlockEntity flower) {
            super(flower);
        }

        @Override
        public void renderHUD(class_332 gui, class_310 mc) {
            String filter = class_1074.method_4662((String)("botaniamisc.pollidisiac." + ((PollidisiacBlockEntity)this.flower).getMode().method_15434()), (Object[])new Object[0]);
            int filterWidth = mc.field_1772.method_1727(filter);
            int filterTextStart = (mc.method_22683().method_4486() - filterWidth) / 2;
            int halfMinWidth = (filterWidth + 4) / 2;
            int centerY = mc.method_22683().method_4502() / 2;
            super.renderHUD(gui, mc, halfMinWidth, halfMinWidth, 40);
            gui.method_25303(mc.field_1772, filter, filterTextStart, centerY + 30, ((PollidisiacBlockEntity)this.flower).getColor());
        }
    }
}

