/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.fabric.mixin;

import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import vazkii.botania.common.item.BotaniaItems;

@Mixin(class_1799.class)
public abstract class ItemStackFabricMixin {
	@Shadow
	public abstract boolean is(class_1792 item);

	@Inject(at = @At("HEAD"), method = "is(Lnet/minecraft/world/item/Item;)Z", cancellable = true)
	private void isBotaniaShears(class_1792 item, CallbackInfoReturnable<Boolean> cir) {
		if (item == class_1802.field_8868) {
			if (is(BotaniaItems.manasteelShears) || is(BotaniaItems.elementiumShears)) {
				cir.setReturnValue(true);
			}
		}
	}
}
