/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.tool.manasteel;

import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.SortableTool;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.item.equipment.CustomDamageItem;
import vazkii.botania.common.item.equipment.tool.ToolCommons;

import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1794;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1937;
import net.minecraft.class_2680;

public class ManasteelHoeItem extends class_1794 implements CustomDamageItem, SortableTool {
	private static final int MANA_PER_DAMAGE = 60;

	public ManasteelHoeItem(class_1793 props) {
		this(BotaniaAPI.instance().getManasteelItemTier(), props, -1f);
	}

	public ManasteelHoeItem(class_1832 mat, class_1793 properties, float attackSpeed) {
		super(mat, (int) -mat.method_8028(), attackSpeed, properties);
	}

	@Override
	public <T extends class_1309> int damageItem(class_1799 stack, int amount, T entity, Consumer<T> onBroken) {
		int manaPer = ((ManasteelHoeItem) stack.method_7909()).getManaPerDamage();
		return ToolCommons.damageItemIfPossible(stack, amount, entity, manaPer);
	}

	public int getManaPerDamage() {
		return MANA_PER_DAMAGE;
	}

	@Override
	public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
		if (!world.field_9236 && entity instanceof class_1657 player && stack.method_7919() > 0 && ManaItemHandler.instance().requestManaExactForTool(stack, player, getManaPerDamage() * 2, true)) {
			stack.method_7974(stack.method_7919() - 1);
		}
	}

	@Override
	public int getSortingPriority(class_1799 stack, class_2680 state) {
		return ToolCommons.getToolPriority(stack);
	}
}
