package vazkii.botania.client.integration.emi;

import dev.emi.emi.api.recipe.EmiPatternCraftingRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.GeneratedSlotWidget;
import dev.emi.emi.api.widget.SlotWidget;
import vazkii.botania.common.item.lens.LensItem;

import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1802;

public class CompositeLensEmiRecipe extends EmiPatternCraftingRecipe {
	private static final EmiStack SLIME = EmiStack.of(class_1802.field_8777);
	private final List<EmiStack> lenses;

	@SuppressWarnings("unchecked")
	public CompositeLensEmiRecipe(List<EmiStack> lenses) {
		super((List<EmiIngredient>) (List<?>) lenses, EmiStack.EMPTY, null);
		this.lenses = lenses;
	}

	@Override
	public List<EmiStack> getOutputs() {
		return lenses;
	}

	@Override
	public SlotWidget getInputWidget(int slot, int x, int y) {
		if (slot == 0) {
			return new GeneratedSlotWidget(r -> lenses.get(r.nextInt(lenses.size())), unique, x, y);
		} else if (slot == 1) {
			return new SlotWidget(SLIME, x, y);
		} else if (slot == 2) {
			return new GeneratedSlotWidget(r -> lenses.get(r.nextInt(1) + r.nextInt(lenses.size())), unique, x, y);
		}
		return new SlotWidget(EmiStack.EMPTY, x, y);
	}

	@Override
	public SlotWidget getOutputWidget(int x, int y) {
		return new GeneratedSlotWidget(r -> {
			class_1799 a = lenses.get(r.nextInt(lenses.size())).getItemStack();
			class_1799 b = lenses.get(r.nextInt(lenses.size())).getItemStack();
			((LensItem) a.method_7909()).setCompositeLens(a.method_7972(), b);
			return EmiStack.of(a);
		}, unique, x, y);
	}
}
