/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.fx;

import com.mojang.serialization.Codec;
import net.minecraft.class_2396;
import net.minecraft.class_4002;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import org.jetbrains.annotations.NotNull;

public class SparkleParticleType extends class_2396<SparkleParticleData> {
	public SparkleParticleType() {
		super(false, SparkleParticleData.DESERIALIZER);
	}

	@NotNull
	@Override
	public Codec<SparkleParticleData> method_29138() {
		return SparkleParticleData.CODEC;
	}

	public static class Factory implements class_707<SparkleParticleData> {
		private final class_4002 sprite;

		public Factory(class_4002 sprite) {
			this.sprite = sprite;
		}

		@Override
		public class_703 createParticle(SparkleParticleData data, class_638 world, double x, double y, double z, double mx, double my, double mz) {
			return new FXSparkle(world, x, y, z, data.size, data.r, data.g, data.b, data.m, data.fake, data.noClip, data.corrupt, sprite);
		}
	}
}
