/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.patchouli.processor;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import vazkii.botania.api.recipe.ElvenTradeRecipe;
import vazkii.botania.client.patchouli.PatchouliUtils;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class ElvenTradeProcessor
implements IComponentProcessor {
    private List<ElvenTradeRecipe> recipes;
    private int longestIngredientSize;
    private int mostInputs;
    private int mostOutputs;

    public void setup(class_1937 level, IVariableProvider variables) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (IVariable s : variables.get("recipes").asListOrSingleton()) {
            ElvenTradeRecipe recipe = PatchouliUtils.getRecipe(level, BotaniaRecipeTypes.ELVEN_TRADE_TYPE, new class_2960(s.asString()));
            if (recipe == null) continue;
            builder.add((Object)recipe);
        }
        this.recipes = builder.build();
        for (ElvenTradeRecipe recipe : this.recipes) {
            class_2371<class_1856> inputs = recipe.method_8117();
            for (class_1856 ingredient : inputs) {
                int length = ingredient.method_8105().length;
                if (length <= this.longestIngredientSize) continue;
                this.longestIngredientSize = length;
            }
            if (inputs.size() > this.mostInputs) {
                this.mostInputs = inputs.size();
            }
            if (recipe.getOutputs().size() <= this.mostOutputs) continue;
            this.mostOutputs = recipe.getOutputs().size();
        }
    }

    public IVariable process(class_1937 level, String key) {
        int index;
        if (this.recipes.isEmpty()) {
            return null;
        }
        if (key.equals("heading")) {
            return IVariable.from((Object)this.recipes.get(0).getOutputs().get(0).method_7964());
        }
        if (key.startsWith("input")) {
            int index2 = Integer.parseInt(key.substring(5)) - 1;
            if (index2 < this.mostInputs) {
                return this.interweaveIngredients(index2);
            }
            return null;
        }
        if (key.startsWith("output") && (index = Integer.parseInt(key.substring(6)) - 1) < this.mostOutputs) {
            return IVariable.wrapList((Iterable)this.recipes.stream().map(ElvenTradeRecipe::getOutputs).map(l -> index < l.size() ? (class_1799)l.get(index) : class_1799.field_8037).map(IVariable::from).collect(Collectors.toList()));
        }
        return null;
    }

    private IVariable interweaveIngredients(int inputIndex) {
        List<class_1856> recipes = this.recipes.stream().map(ElvenTradeRecipe::method_8117).map(ingredients -> {
            if (inputIndex < ingredients.size()) {
                return (class_1856)ingredients.get(inputIndex);
            }
            return class_1856.field_9017;
        }).collect(Collectors.toList());
        return PatchouliUtils.interweaveIngredients(recipes, this.longestIngredientSize);
    }
}

