/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.tool.elementium;

import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.annotations.SoftImplement;
import vazkii.botania.common.item.equipment.tool.manasteel.ManasteelAxeItem;

import java.util.function.Consumer;
import net.minecraft.class_1282;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_8567;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class ElementiumAxeItem extends ManasteelAxeItem {
	public static final class_2960 BEHEADING_LOOT_TABLE = prefix("elementium_axe_beheading");

	public ElementiumAxeItem(class_1793 props) {
		super(BotaniaAPI.instance().getElementiumItemTier(), 6F, -3.1F, props);
	}

	public static void onEntityDrops(boolean hitRecently, class_1282 source, class_1309 target,
			Consumer<class_1799> consumer) {
		class_8567.class_8568 ctx = (new class_8567.class_8568((class_3218) target.method_37908()))
				.method_51874(class_181.field_1226, target)
				.method_51874(class_181.field_24424, target.method_19538())
				.method_51874(class_181.field_1231, source)
				.method_51877(class_181.field_1230, source.method_5529())
				.method_51877(class_181.field_1227, source.method_5526());

		if (hitRecently && target.method_6124() != null && target.method_6124() instanceof class_1657 p) {
			ctx = ctx.method_51874(class_181.field_1233, p).method_51871(p.method_7292());
		}

		target.method_37908().method_8503().method_3857().getLootTable(BEHEADING_LOOT_TABLE)
				.method_51880(ctx.method_51875(class_173.field_1173), target.method_51851(), consumer);
	}

	@SoftImplement("IForgeItem")
	public boolean canApplyAtEnchantingTable(class_1799 stack, class_1887 enchantment) {
		if (enchantment == class_1893.field_9110) {
			return true;
		} else {
			// Copy the default impl
			return enchantment.field_9083.method_8177(this);
		}

	}

	// [VanillaCopy] modified from DiggerItem::hurtEnemy, actually same as SwordItem::hurtEnemy
	@Override
	public boolean method_7873(class_1799 stack, @NotNull class_1309 target, @NotNull class_1309 attacker) {
		// only do 1 durability damage, since this is primarily a weapon
		stack.method_7956(1, attacker, living -> living.method_20235(class_1304.field_6173));
		return true;
	}

}
