/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.mana;

import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2464;
import net.minecraft.class_247;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_3726;
import net.minecraft.class_3727;
import net.minecraft.class_3965;
import net.minecraft.class_5558;
import net.minecraft.world.item.*;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.state.BotaniaStateProperties.OptionalDyeColor;
import vazkii.botania.common.block.BotaniaWaterloggedBlock;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.mana.ManaPoolBlockEntity;
import vazkii.botania.common.block.decor.BotaniaMushroomBlock;
import vazkii.botania.common.entity.ManaBurstEntity;
import vazkii.botania.common.item.material.MysticalPetalItem;

import java.util.List;
import java.util.Optional;

import static vazkii.botania.api.state.BotaniaStateProperties.OPTIONAL_DYE_COLOR;

public class ManaPoolBlock extends BotaniaWaterloggedBlock implements class_2343 {
	private static final class_265 NORMAL_SHAPE;
	private static final class_265 DILUTED_SHAPE;
	private static final class_265 CREATIVE_SHAPE;
	private static final class_265 NORMAL_SHAPE_INTERACT;
	private static final class_265 DILUTED_SHAPE_INTERACT;
	private static final class_265 CREATIVE_SHAPE_INTERACT;
	static {
		NORMAL_SHAPE_INTERACT = method_9541(0, 0, 0, 16, 8, 16);
		DILUTED_SHAPE_INTERACT = method_9541(0, 0, 0, 16, 6, 16);
		CREATIVE_SHAPE_INTERACT = method_9541(0, 0, 0, 16, 10, 16);

		class_265 cutout = method_9541(2, 2, 2, 14, 16, 14);
		class_265 dilutedCutout = method_9541(1, 1, 1, 15, 6, 15);

		NORMAL_SHAPE = class_259.method_1072(NORMAL_SHAPE_INTERACT, cutout, class_247.field_16886);
		DILUTED_SHAPE = class_259.method_1072(DILUTED_SHAPE_INTERACT, dilutedCutout, class_247.field_16886);
		CREATIVE_SHAPE = class_259.method_1072(CREATIVE_SHAPE_INTERACT, cutout, class_247.field_16886);
	}

	public enum Variant {
		DEFAULT,
		CREATIVE,
		DILUTED,
		FABULOUS
	}

	public final Variant variant;

	public ManaPoolBlock(Variant v, class_2251 builder) {
		super(builder);
		this.variant = v;
		method_9590(method_9564().method_11657(OPTIONAL_DYE_COLOR, OptionalDyeColor.NONE));
	}

	@Override
	protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
		super.method_9515(builder);
		builder.method_11667(OPTIONAL_DYE_COLOR);
	}

	@Override
	public void method_9568(class_1799 stack, @Nullable class_1922 world, List<class_2561> tooltip, class_1836 flag) {
		super.method_9568(stack, world, tooltip, flag);
		if (variant == ManaPoolBlock.Variant.CREATIVE) {
			for (int i = 0; i < 2; i++) {
				tooltip.add(class_2561.method_43471("botaniamisc.creativePool" + i).method_27692(class_124.field_1080));
			}
		}
	}

	@NotNull
	@Override
	public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 ctx) {
		return switch (this.variant) {
			case DILUTED -> DILUTED_SHAPE;
			case CREATIVE -> CREATIVE_SHAPE;
			case DEFAULT, FABULOUS -> NORMAL_SHAPE;
		};
	}

	@Override
	public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
		if (context instanceof class_3727 econtext
				&& econtext.method_32480() instanceof ManaBurstEntity) {
			// Sometimes the pool's collision box is too thin for bursts shot straight up.
			return switch (this.variant) {
				case DILUTED -> DILUTED_SHAPE_INTERACT;
				case CREATIVE -> CREATIVE_SHAPE_INTERACT;
				case DEFAULT, FABULOUS -> NORMAL_SHAPE_INTERACT;
			};
		} else {
			return super.method_9549(state, world, pos, context);
		}
	}

	@NotNull
	@Override
	public class_265 method_9584(class_2680 state, class_1922 level, class_2338 pos) {
		return switch (this.variant) {
			case DILUTED -> DILUTED_SHAPE_INTERACT;
			case CREATIVE -> CREATIVE_SHAPE_INTERACT;
			case DEFAULT, FABULOUS -> NORMAL_SHAPE_INTERACT;
		};
	}

	@NotNull
	@Override
	public class_1269 method_9534(@NotNull class_2680 state, class_1937 world, @NotNull class_2338 pos, class_1657 player, @NotNull class_1268 hand, @NotNull class_3965 hit) {
		class_2586 be = world.method_8321(pos);
		class_1799 stack = player.method_5998(hand);
		Optional<class_1767> itemColor = Optional.empty();
		if (stack.method_7909() instanceof MysticalPetalItem petalItem) {
			itemColor = Optional.of(petalItem.color);
		}
		if (class_2248.method_9503(stack.method_7909()) instanceof BotaniaMushroomBlock mushroomBlock) {
			itemColor = Optional.of(mushroomBlock.color);
		}
		if (itemColor.isPresent() && be instanceof ManaPoolBlockEntity pool) {
			if (!itemColor.equals(pool.getColor())) {
				pool.setColor(itemColor);
				if (!player.method_31549().field_7477) {
					stack.method_7934(1);
				}
				return class_1269.method_29236(world.method_8608());
			}
		}
		if (stack.method_31574(class_1802.field_8696) && be instanceof ManaPoolBlockEntity pool && pool.getColor().isPresent()) {
			pool.setColor(Optional.empty());
			if (!player.method_31549().field_7477) {
				stack.method_7934(1);
			}
			return class_1269.method_29236(world.method_8608());
		}
		return super.method_9534(state, world, pos, player, hand, hit);
	}

	@NotNull
	@Override
	public class_2586 method_10123(@NotNull class_2338 pos, @NotNull class_2680 state) {
		return new ManaPoolBlockEntity(pos, state);
	}

	@Nullable
	@Override
	public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> type) {
		return createTickerHelper(type, BotaniaBlockEntities.POOL, level.field_9236 ? ManaPoolBlockEntity::clientTick : ManaPoolBlockEntity::serverTick);
	}

	@Override
	public void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
		if (entity instanceof class_1542 item) {
			ManaPoolBlockEntity tile = (ManaPoolBlockEntity) world.method_8321(pos);
			tile.collideEntityItem(item);
		}
	}

	@NotNull
	@Override
	public class_2464 method_9604(class_2680 state) {
		if (variant == Variant.FABULOUS) {
			return class_2464.field_11456;
		} else {
			return class_2464.field_11458;
		}
	}

	@Override
	public boolean method_9498(class_2680 state) {
		return true;
	}

	@Override
	public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
		ManaPoolBlockEntity pool = (ManaPoolBlockEntity) world.method_8321(pos);
		return ManaPoolBlockEntity.calculateComparatorLevel(pool.getCurrentMana(), pool.getMaxMana());
	}
}
