/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block;

import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_6088;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.api.mana.ManaTrigger;
import vazkii.botania.common.entity.BotaniaEntities;
import vazkii.botania.common.entity.ManaStormEntity;

public class ManastormChargeBlock extends BotaniaBlock {

	public ManastormChargeBlock(class_2251 builder) {
		super(builder);
	}

	public static class ManaTriggerImpl implements ManaTrigger {
		private final class_1937 world;
		private final class_2338 pos;
		private final class_2680 state;

		public ManaTriggerImpl(class_1937 world, class_2338 pos, class_2680 state) {
			this.world = world;
			this.pos = pos;
			this.state = state;
		}

		@Override
		public void onBurstCollision(ManaBurst burst) {
			if (!burst.isFake() && !world.field_9236) {
				world.method_20290(class_6088.field_31144, pos, class_2248.method_9507(state));
				world.method_8650(pos, false);
				ManaStormEntity storm = BotaniaEntities.MANA_STORM.method_5883(world);
				storm.burstColor = burst.getColor();
				storm.method_5814(pos.method_10263() + 0.5, pos.method_10264() + 0.5, pos.method_10260() + 0.5);
				world.method_8649(storm);
			}
		}
	}
}
