/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.render.world;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.lib.ResourcesLib;
import vazkii.botania.common.helper.VecHelper;

import java.util.Random;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_5944;
import net.minecraft.class_638;
import net.minecraft.class_757;
import net.minecraft.class_758;

public class SkyblockSkyRenderer {

	private static final class_2960 textureSkybox = new class_2960(ResourcesLib.MISC_SKYBOX);
	private static final class_2960 textureRainbow = new class_2960(ResourcesLib.MISC_RAINBOW);
	private static final class_2960[] planetTextures = new class_2960[] {
			new class_2960(ResourcesLib.MISC_PLANET + "0.png"),
			new class_2960(ResourcesLib.MISC_PLANET + "1.png"),
			new class_2960(ResourcesLib.MISC_PLANET + "2.png"),
			new class_2960(ResourcesLib.MISC_PLANET + "3.png"),
			new class_2960(ResourcesLib.MISC_PLANET + "4.png"),
			new class_2960(ResourcesLib.MISC_PLANET + "5.png")
	};

	public static void renderExtra(class_4587 ms, class_638 world, float partialTicks, float insideVoid) {
		// Botania - Begin extra stuff
		class_289 tessellator = class_289.method_1348();
		float rain = 1.0F - world.method_8430(partialTicks);
		float celAng = world.method_30274(partialTicks);
		float effCelAng = celAng;
		if (celAng > 0.5) {
			effCelAng = 0.5F - (celAng - 0.5F);
		}

		// === Planets
		float scale = 20F;
		float lowA = Math.max(0F, effCelAng - 0.3F) * rain;
		float a = Math.max(0.1F, lowA);

		RenderSystem.blendFuncSeparate(770, 771, 1, 0);
		ms.method_22903();
		RenderSystem.setShaderColor(1F, 1F, 1F, a * 4 * (1F - insideVoid));
		ms.method_22907(new Quaternionf().rotateAxis(VecHelper.toRadians(90), 0.5F, 0.5F, 0F));
		for (int p = 0; p < planetTextures.length; p++) {
			RenderSystem.setShader(class_757::method_34542);
			RenderSystem.setShaderTexture(0, planetTextures[p]);
			Matrix4f mat = ms.method_23760().method_23761();
			tessellator.method_1349().method_1328(class_293.class_5596.field_27382, class_290.field_1585);
			tessellator.method_1349().method_22918(mat, -scale, 100, -scale).method_22913(0.0F, 0.0F).method_1344();
			tessellator.method_1349().method_22918(mat, scale, 100, -scale).method_22913(1.0F, 0.0F).method_1344();
			tessellator.method_1349().method_22918(mat, scale, 100, scale).method_22913(1.0F, 1.0F).method_1344();
			tessellator.method_1349().method_22918(mat, -scale, 100, scale).method_22913(0.0F, 1.0F).method_1344();
			tessellator.method_1350();

			switch (p) {
				case 0 -> {
					ms.method_22907(VecHelper.rotateX(70));
					scale = 12F;
				}
				case 1 -> {
					ms.method_22907(VecHelper.rotateZ(120));
					scale = 15F;
				}
				case 2 -> {
					ms.method_22907(new Quaternionf().rotateAxis(VecHelper.toRadians(80), 1, 0, 1));
					scale = 25F;
				}
				case 3 -> {
					ms.method_22907(VecHelper.rotateZ(100));
					scale = 10F;
				}
				case 4 -> {
					ms.method_22907(new Quaternionf().rotateAxis(VecHelper.toRadians(-60), 1, 0, 0.5F));
					scale = 40F;
				}
			}
		}
		RenderSystem.setShaderColor(1F, 1F, 1F, 1F);
		ms.method_22909();

		// === Rays
		RenderSystem.setShaderTexture(0, textureSkybox);

		scale = 20F;
		a = lowA;
		ms.method_22903();
		RenderSystem.blendFuncSeparate(770, 1, 1, 0);
		ms.method_46416(0, -1, 0);
		ms.method_22907(VecHelper.rotateX(220));
		RenderSystem.setShaderColor(1F, 1F, 1F, a);
		int angles = 90;
		float y = 2F;
		float y0 = 0F;
		float uPer = 1F / 360F;
		float anglePer = 360F / angles;
		double fuzzPer = Math.PI * 10 / angles;
		float rotSpeed = 1F;
		float rotSpeedMod = 0.4F;

		for (int p = 0; p < 3; p++) {
			float baseAngle = rotSpeed * rotSpeedMod * (ClientTickHandler.ticksInGame + ClientTickHandler.partialTicks);
			ms.method_22907(VecHelper.rotateY((ClientTickHandler.ticksInGame + ClientTickHandler.partialTicks) * 0.25F * rotSpeed * rotSpeedMod));

			Matrix4f mat = ms.method_23760().method_23761();
			tessellator.method_1349().method_1328(class_293.class_5596.field_27382, class_290.field_1585);
			for (int i = 0; i < angles; i++) {
				int j = i;
				if (i % 2 == 0) {
					j--;
				}

				float ang = j * anglePer + baseAngle;
				float xp = (float) Math.cos(ang * Math.PI / 180F) * scale;
				float zp = (float) Math.sin(ang * Math.PI / 180F) * scale;
				float yo = (float) Math.sin(fuzzPer * j) * 1;

				float ut = ang * uPer;
				if (i % 2 == 0) {
					tessellator.method_1349().method_22918(mat, xp, yo + y0 + y, zp).method_22913(ut, 1F).method_1344();
					tessellator.method_1349().method_22918(mat, xp, yo + y0, zp).method_22913(ut, 0).method_1344();
				} else {
					tessellator.method_1349().method_22918(mat, xp, yo + y0, zp).method_22913(ut, 0).method_1344();
					tessellator.method_1349().method_22918(mat, xp, yo + y0 + y, zp).method_22913(ut, 1F).method_1344();
				}

			}
			tessellator.method_1350();

			switch (p) {
				case 0 -> {
					ms.method_22907(VecHelper.rotateX(20));
					RenderSystem.setShaderColor(1F, 0.4F, 0.4F, a);
					fuzzPer = Math.PI * 14 / angles;
					rotSpeed = 0.2F;
				}
				case 1 -> {
					ms.method_22907(VecHelper.rotateX(50));
					RenderSystem.setShaderColor(0.4F, 1F, 0.7F, a);
					fuzzPer = Math.PI * 6 / angles;
					rotSpeed = 2F;
				}
			}
		}
		ms.method_22909();

		// === Rainbow
		ms.method_22903();
		GlStateManager._blendFuncSeparate(770, 771, 1, 0);
		RenderSystem.setShaderTexture(0, textureRainbow);
		scale = 10F;
		float effCelAng1 = celAng;
		if (effCelAng1 > 0.25F) {
			effCelAng1 = 1F - effCelAng1;
		}
		effCelAng1 = 0.25F - Math.min(0.25F, effCelAng1);

		long time = world.method_8532() + 1000;
		int day = (int) (time / 24000L);
		Random rand = new Random(day * 0xFF);
		float angle1 = rand.nextFloat() * 360F;
		float angle2 = rand.nextFloat() * 360F;
		RenderSystem.setShaderColor(1F, 1F, 1F, effCelAng1 * (1F - insideVoid));
		ms.method_22907(VecHelper.rotateY(angle1));
		ms.method_22907(VecHelper.rotateZ(angle2));

		Matrix4f mat = ms.method_23760().method_23761();
		tessellator.method_1349().method_1328(class_293.class_5596.field_27382, class_290.field_1585);
		for (int i = 0; i < angles; i++) {
			int j = i;
			if (i % 2 == 0) {
				j--;
			}

			float ang = j * anglePer;
			float xp = (float) Math.cos(ang * Math.PI / 180F) * scale;
			float zp = (float) Math.sin(ang * Math.PI / 180F) * scale;
			float yo = 0;

			float ut = ang * uPer;
			if (i % 2 == 0) {
				tessellator.method_1349().method_22918(mat, xp, yo + y0 + y, zp).method_22913(ut, 1F).method_1344();
				tessellator.method_1349().method_22918(mat, xp, yo + y0, zp).method_22913(ut, 0).method_1344();
			} else {
				tessellator.method_1349().method_22918(mat, xp, yo + y0, zp).method_22913(ut, 0).method_1344();
				tessellator.method_1349().method_22918(mat, xp, yo + y0 + y, zp).method_22913(ut, 1F).method_1344();
			}

		}
		tessellator.method_1350();
		ms.method_22909();
		RenderSystem.setShaderColor(1F, 1F, 1F, 1F - insideVoid);
		GlStateManager._blendFuncSeparate(770, 1, 1, 0);
	}

	public static void renderStars(class_291 starVBO, class_4587 ms, Matrix4f projMat, float partialTicks, Runnable resetFog) {
		class_758.method_23792();
		class_310 mc = class_310.method_1551();
		class_5944 shader = class_757.method_34539();
		float rain = 1.0F - mc.field_1687.method_8430(partialTicks);
		float celAng = mc.field_1687.method_30274(partialTicks);
		float effCelAng = celAng;
		if (celAng > 0.5) {
			effCelAng = 0.5F - (celAng - 0.5F);
		}
		float alpha = rain * Math.max(0.1F, effCelAng * 2);

		float t = (ClientTickHandler.ticksInGame + partialTicks + 2000) * 0.005F;
		ms.method_22903();
		starVBO.method_1353();

		ms.method_22903();
		ms.method_22907(VecHelper.rotateY(t * 3));
		RenderSystem.setShaderColor(1F, 1F, 1F, alpha);
		starVBO.method_34427(ms.method_23760().method_23761(), projMat, shader);
		ms.method_22909();

		ms.method_22903();
		ms.method_22907(VecHelper.rotateY(t));
		RenderSystem.setShaderColor(0.5F, 1F, 1F, alpha);
		starVBO.method_34427(ms.method_23760().method_23761(), projMat, shader);
		ms.method_22909();

		ms.method_22903();
		ms.method_22907(VecHelper.rotateY(t * 2));
		RenderSystem.setShaderColor(1F, 0.75F, 0.75F, alpha);
		starVBO.method_34427(ms.method_23760().method_23761(), projMat, shader);
		ms.method_22909();

		ms.method_22903();
		ms.method_22907(VecHelper.rotateZ(t * 3));
		RenderSystem.setShaderColor(1F, 1F, 1F, 0.25F * alpha);
		starVBO.method_34427(ms.method_23760().method_23761(), projMat, shader);
		ms.method_22909();

		ms.method_22903();
		ms.method_22907(VecHelper.rotateZ(t));
		RenderSystem.setShaderColor(0.5F, 1F, 1F, 0.25F * alpha);
		starVBO.method_34427(ms.method_23760().method_23761(), projMat, shader);
		ms.method_22909();

		ms.method_22903();
		ms.method_22907(VecHelper.rotateZ(t * 2));
		RenderSystem.setShaderColor(1F, 0.75F, 0.75F, 0.25F * alpha);
		starVBO.method_34427(ms.method_23760().method_23761(), projMat, shader);
		ms.method_22909();

		ms.method_22909();
		class_291.method_1354();
		resetFog.run();
	}

}
