/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.test.item;

import java.util.Objects;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_2183;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3965;
import net.minecraft.class_4516;
import net.minecraft.class_4970;
import net.minecraft.class_5544;
import net.minecraft.class_6302;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.mana.ManaItem;
import vazkii.botania.common.item.AstrolabeItem;
import vazkii.botania.common.item.BlackHoleTalismanItem;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.test.TestingUtil;
import vazkii.botania.xplat.XplatAbstractions;

public class AstrolabeTest {
    private static final String TEMPLATE_CANDLES = "botania:item/astrolabe_candles";
    private static final class_2248 BLOCK_CANDLES = class_2246.field_27104;
    private static final class_2338 POS_WATER_SLAB = new class_2338(2, 2, 3);
    private static final class_2338 POS_SEAGRASS = new class_2338(2, 2, 1);
    private static final class_2338 POS_SUPPORTED_CANDLE = new class_2338(2, 4, 1);
    private static final class_2338 POS_FLOATING_CANDLE = new class_2338(2, 4, 3);
    private static final class_243 POS_PLAYER_CANDLES = new class_243(0.5, 3.0, 2.5);
    private static final class_243 LOOK_TARGET_CANDLES_HORIZONTAL = new class_243(2.1, 2.0, 2.5);
    private static final class_243 LOOK_TARGET_CANDLES_VERTICAL = new class_243(2.9, 2.0, 2.5);
    private static final int EXPECTED_REMAINING_CANDLES_HORIZONTAL_3X3 = 56;
    private static final int EXPECTED_REMAINING_CANDLES_VERTICAL_3X3 = 60;
    private static final int EXPECTED_REMAINING_CANDLES_VERTICAL_5X5 = 58;
    private static final int SLOT_FIRST_PROVIDER = 2;
    private static final int SLOT_SECOND_PROVIDER = 3;
    private static final String TEMPLATE_DIRECTIONAL = "botania:item/astrolabe_directional";
    private static final class_2248 BLOCK_LOG = class_2246.field_10431;
    private static final class_2248 BLOCK_PISTON = class_2246.field_10560;
    private static final class_243 POS_PLAYER_DIRECTIONAL = new class_243(1.0, 2.0, 0.5);
    private static final class_243 LOOK_TARGET_DIRECTIONAL_X = new class_243(2.5, 2.0, 3.0);
    private static final class_243 LOOK_TARGET_DIRECTIONAL_Y = new class_243(2.1, 2.0, 2.5);
    private static final class_243 LOOK_TARGET_DIRECTIONAL_Z = new class_243(2.5, 2.0, 2.5);
    private static final String TEMPLATE_MANA = "botania:item/astrolabe_mana";
    private static final class_243 POS_PLAYER_MANA = new class_243(6.5, 2.0, 6.5);
    private static final int SIZE_ASTROLABE = 11;
    private static final int COST_ASTROLABE = 3520;
    private static final int MANA_NOT_ENOUGH = 15000;
    private static final int MANA_BARELY_ENOUGH = 19910;
    private static final int SLOT_TABLET = 1;

    @class_6302(method_35936="botania:item/astrolabe_candles")
    public void testCandlesHorizontal3x3(class_4516 helper) {
        class_1657 player = this.mockPlayerWithAstrolabe(helper, POS_PLAYER_CANDLES, LOOK_TARGET_CANDLES_HORIZONTAL, 500000);
        player.method_7270(new class_1799((class_1935)BLOCK_CANDLES.method_8389(), 64));
        class_1799 stack = this.getAstrolabeForBlockType(player, BLOCK_CANDLES);
        this.useAstrolabe(player, stack, class_1268.field_5808);
        this.checkWaterSlabAndSeaGrass(helper);
        helper.method_36017(POS_WATER_SLAB.method_10084(), class_4970.class_4971::method_26215, () -> "Expected air above water slab, but found " + helper.method_35980(POS_WATER_SLAB.method_10084()));
        helper.method_36017(POS_SEAGRASS.method_10084(), state -> state.method_27852(class_2246.field_10136), () -> "Expected slab above sea grass, but found " + helper.method_35980(POS_SEAGRASS.method_10084()));
        for (class_2338 pos : class_2338.method_10094((int)1, (int)2, (int)1, (int)3, (int)2, (int)3)) {
            if (pos.equals((Object)POS_WATER_SLAB)) continue;
            helper.method_36017(pos, block -> block.method_27852(BLOCK_CANDLES), () -> "Missing candle, found " + helper.method_35980(pos));
            helper.method_35987(pos, (class_2769)class_5544.field_27176, (Comparable)Boolean.valueOf(true));
        }
        this.checkRemainingCandles(player, 56, 2);
        this.checkRemainingMana(player, 499040);
        helper.method_36036();
    }

    @class_6302(method_35936="botania:item/astrolabe_candles")
    public void testCandlesHorizontal3x3Offhand(class_4516 helper) {
        class_1657 player = this.mockPlayerWithAstrolabe(helper, POS_PLAYER_CANDLES, LOOK_TARGET_CANDLES_HORIZONTAL, 500000);
        player.method_7270(new class_1799((class_1935)BLOCK_CANDLES.method_8389(), 64));
        class_1799 stack = this.getAstrolabeForBlockType(player, BLOCK_CANDLES);
        player.method_6122(class_1268.field_5810, stack);
        player.method_6122(class_1268.field_5808, class_1799.field_8037);
        this.useAstrolabe(player, stack, class_1268.field_5810);
        this.checkRemainingCandles(player, 56, 2);
        this.checkRemainingMana(player, 499040);
        helper.method_36036();
    }

    @class_6302(method_35936="botania:item/astrolabe_candles")
    public void testCandlesHorizontal3x3MultipleSourcesTalismanLast(class_4516 helper) {
        class_1657 player = this.mockPlayerWithAstrolabe(helper, POS_PLAYER_CANDLES, LOOK_TARGET_CANDLES_HORIZONTAL, 500000);
        player.method_7270(new class_1799((class_1935)BLOCK_CANDLES.method_8389(), 5));
        class_1799 blackHoleTalisman = new class_1799((class_1935)BotaniaItems.blackHoleTalisman);
        BlackHoleTalismanItem.setBlock(blackHoleTalisman, BLOCK_CANDLES);
        BlackHoleTalismanItem.setCount(blackHoleTalisman, 5);
        player.method_7270(blackHoleTalisman);
        class_1799 stack = this.getAstrolabeForBlockType(player, BLOCK_CANDLES);
        this.useAstrolabe(player, stack, class_1268.field_5808);
        this.checkRemainingCandles(player, 0, 2);
        this.checkRemainingTalismanCandles(player, 2, 3);
        this.checkRemainingMana(player, 499040);
        helper.method_36036();
    }

    @class_6302(method_35936="botania:item/astrolabe_candles")
    public void testCandlesHorizontal3x3MultipleSourcesTalismanFirst(class_4516 helper) {
        class_1657 player = this.mockPlayerWithAstrolabe(helper, POS_PLAYER_CANDLES, LOOK_TARGET_CANDLES_HORIZONTAL, 500000);
        class_1799 blackHoleTalisman = new class_1799((class_1935)BotaniaItems.blackHoleTalisman);
        BlackHoleTalismanItem.setBlock(blackHoleTalisman, BLOCK_CANDLES);
        BlackHoleTalismanItem.setCount(blackHoleTalisman, 5);
        player.method_7270(blackHoleTalisman);
        player.method_7270(new class_1799((class_1935)BLOCK_CANDLES.method_8389(), 5));
        class_1799 stack = this.getAstrolabeForBlockType(player, BLOCK_CANDLES);
        this.useAstrolabe(player, stack, class_1268.field_5808);
        this.checkRemainingCandles(player, 2, 3);
        this.checkRemainingTalismanCandles(player, 0, 2);
        this.checkRemainingMana(player, 499040);
        helper.method_36036();
    }

    @class_6302(method_35936="botania:item/astrolabe_candles")
    public void testCandlesVertical3x3(class_4516 helper) {
        class_1657 player = this.mockPlayerWithAstrolabe(helper, POS_PLAYER_CANDLES, LOOK_TARGET_CANDLES_VERTICAL, 500000);
        player.method_7270(new class_1799((class_1935)BLOCK_CANDLES.method_8389(), 64));
        class_1799 stack = this.getAstrolabeForBlockType(player, BLOCK_CANDLES);
        this.useAstrolabe(player, stack, class_1268.field_5808);
        this.checkThreeByThreeVerticalCandleArea(helper);
        this.checkRemainingCandles(player, 60, 2);
        this.checkRemainingMana(player, 499040);
        helper.method_36036();
    }

    @class_6302(method_35936="botania:item/astrolabe_candles")
    public void testCandlesVertical5x5(class_4516 helper) {
        class_1657 player = this.mockPlayerWithAstrolabe(helper, POS_PLAYER_CANDLES, LOOK_TARGET_CANDLES_VERTICAL, 500000);
        player.method_7270(new class_1799((class_1935)BLOCK_CANDLES.method_8389(), 64));
        class_1799 stack = this.getAstrolabeForBlockType(player, BLOCK_CANDLES);
        AstrolabeItem.setSize(stack, 5);
        this.useAstrolabe(player, stack, class_1268.field_5808);
        this.checkThreeByThreeVerticalCandleArea(helper);
        helper.method_36017(POS_WATER_SLAB.method_10084().method_10072(), block -> block.method_27852(BLOCK_CANDLES), () -> "Expected candle on rim next to water slab, but found " + helper.method_35980(POS_WATER_SLAB.method_10084().method_10072()));
        helper.method_36017(POS_SEAGRASS.method_10084().method_10095(), block -> block.method_27852(BLOCK_CANDLES), () -> "Expected candle on rim next to seagrass, but found " + helper.method_35980(POS_WATER_SLAB.method_10084().method_10095()));
        this.checkRemainingCandles(player, 58, 2);
        this.checkRemainingMana(player, 498400);
        helper.method_36036();
    }

    private void checkRemainingCandles(class_1657 player, int expectedRemaining, int candlesSlot) {
        class_1799 remainingCandles = player.method_31548().method_5438(candlesSlot);
        TestingUtil.assertThat(expectedRemaining == 0 || remainingCandles.method_31574(class_1802.field_27029), () -> "Unexpected item in candles slot: " + remainingCandles);
        TestingUtil.assertEquals(expectedRemaining, remainingCandles.method_7947(), () -> String.format("Incorrect number of remaining candles in inventory, expected %d, found %d", expectedRemaining, remainingCandles.method_7947()));
    }

    private void checkRemainingTalismanCandles(class_1657 player, int expectedRemaining, int talismanSlot) {
        class_1799 remainingTalisman = player.method_31548().method_5438(talismanSlot);
        TestingUtil.assertThat(expectedRemaining == 0 || remainingTalisman.method_31574(BotaniaItems.blackHoleTalisman), () -> "Unexpected item in talisman slot: " + remainingTalisman);
        int count = BlackHoleTalismanItem.getBlockCount(remainingTalisman);
        TestingUtil.assertEquals(expectedRemaining, count, () -> String.format("Incorrect number of remaining candles in talisman, expected %d, found %d", expectedRemaining, count));
    }

    private void checkThreeByThreeVerticalCandleArea(class_4516 helper) {
        this.checkWaterSlabAndSeaGrass(helper);
        helper.method_36017(POS_WATER_SLAB.method_10084(), block -> block.method_27852(BLOCK_CANDLES), () -> "Expected candle on water slab, but found " + helper.method_35980(POS_WATER_SLAB.method_10084()));
        helper.method_35987(POS_WATER_SLAB.method_10084(), (class_2769)class_5544.field_27176, (Comparable)Boolean.valueOf(false));
        helper.method_36017(POS_SEAGRASS.method_10084(), state -> state.method_27852(class_2246.field_10136), () -> "Expected slab above sea grass, but found " + helper.method_35980(POS_SEAGRASS.method_10084()));
        helper.method_36017(POS_FLOATING_CANDLE, block -> block.method_27852(BLOCK_CANDLES), () -> "Floating candle was replaced with " + helper.method_35980(POS_FLOATING_CANDLE));
        helper.method_35987(POS_FLOATING_CANDLE, (class_2769)class_5544.field_27174, (Comparable)Integer.valueOf(1));
        helper.method_35987(POS_FLOATING_CANDLE, (class_2769)class_5544.field_27175, (Comparable)Boolean.valueOf(true));
        helper.method_35987(POS_FLOATING_CANDLE, (class_2769)class_5544.field_27176, (Comparable)Boolean.valueOf(false));
        helper.method_36017(POS_SUPPORTED_CANDLE, block -> block.method_27852(BLOCK_CANDLES), () -> "Supported candle was replaced with " + helper.method_35980(POS_FLOATING_CANDLE));
        helper.method_35987(POS_SUPPORTED_CANDLE, (class_2769)class_5544.field_27174, (Comparable)Integer.valueOf(2));
        helper.method_35987(POS_SUPPORTED_CANDLE, (class_2769)class_5544.field_27175, (Comparable)Boolean.valueOf(true));
        helper.method_35987(POS_SUPPORTED_CANDLE, (class_2769)class_5544.field_27176, (Comparable)Boolean.valueOf(false));
        for (class_2338 pos : class_2338.method_10094((int)1, (int)2, (int)1, (int)3, (int)2, (int)3)) {
            if (pos.method_10263() != 2) {
                helper.method_36017(pos, block -> block.method_27852(class_2246.field_10382), () -> "Water was replaced with " + helper.method_35980(pos));
                continue;
            }
            if (pos.equals((Object)POS_WATER_SLAB)) continue;
            helper.method_36017(pos, block -> block.method_27852(BLOCK_CANDLES), () -> "Missing candle, found " + helper.method_35980(pos));
            helper.method_35987(pos, (class_2769)class_5544.field_27176, (Comparable)Boolean.valueOf(true));
        }
    }

    private void checkWaterSlabAndSeaGrass(class_4516 helper) {
        helper.method_36017(POS_WATER_SLAB, block -> block.method_27852(class_2246.field_10136), () -> "Slab was replaced with " + helper.method_35980(POS_WATER_SLAB));
        helper.method_36017(POS_SEAGRASS, block -> !block.method_27852(class_2246.field_10376), () -> "Seagrass was not replaced");
    }

    @class_6302(method_35936="botania:item/astrolabe_directional")
    public void testDirectionalLogsAxisX(class_4516 helper) {
        this.testDirectionalBlockWithProperty(helper, LOOK_TARGET_DIRECTIONAL_X, BLOCK_LOG, class_2741.field_12496, class_2350.class_2351.field_11048);
    }

    @class_6302(method_35936="botania:item/astrolabe_directional")
    public void testDirectionalLogsAxisY(class_4516 helper) {
        this.testDirectionalBlockWithProperty(helper, LOOK_TARGET_DIRECTIONAL_Y, BLOCK_LOG, class_2741.field_12496, class_2350.class_2351.field_11052);
    }

    @class_6302(method_35936="botania:item/astrolabe_directional")
    public void testDirectionalLogsAxisZ(class_4516 helper) {
        this.testDirectionalBlockWithProperty(helper, LOOK_TARGET_DIRECTIONAL_Z, BLOCK_LOG, class_2741.field_12496, class_2350.class_2351.field_11051);
    }

    @class_6302(method_35936="botania:item/astrolabe_directional")
    public void testDirectionalPistonAxisX(class_4516 helper) {
        this.testDirectionalBlockWithProperty(helper, LOOK_TARGET_DIRECTIONAL_X, BLOCK_PISTON, class_2741.field_12525, class_2350.field_11043);
    }

    @class_6302(method_35936="botania:item/astrolabe_directional")
    public void testDirectionalPistonAxisY(class_4516 helper) {
        this.testDirectionalBlockWithProperty(helper, LOOK_TARGET_DIRECTIONAL_Y, BLOCK_PISTON, class_2741.field_12525, class_2350.field_11043);
    }

    @class_6302(method_35936="botania:item/astrolabe_directional")
    public void testDirectionalPistonAxisZ(class_4516 helper) {
        this.testDirectionalBlockWithProperty(helper, LOOK_TARGET_DIRECTIONAL_Z, BLOCK_PISTON, class_2741.field_12525, class_2350.field_11043);
    }

    private <P extends class_2769<V>, V extends Comparable<V>> void testDirectionalBlockWithProperty(class_4516 helper, class_243 lookTarget, class_2248 block, P property, V value) {
        class_1657 player = this.mockPlayerWithAstrolabe(helper, POS_PLAYER_DIRECTIONAL, lookTarget, 500000);
        player.method_7270(new class_1799((class_1935)block.method_8389(), 64));
        class_1799 stack = this.getAstrolabeForBlockType(player, block);
        this.useAstrolabe(player, stack, class_1268.field_5808);
        for (class_2338 pos : class_2338.method_10094((int)1, (int)2, (int)2, (int)3, (int)4, (int)2)) {
            helper.method_36017(pos, state -> state.method_27852(block), () -> String.format("Expected %s but found %s", block, helper.method_35980(pos).method_26204()));
            helper.method_35988(pos, property, prop -> prop.equals(value), String.format("Expected %s to be %s, but found %s", property.method_11899(), value, helper.method_35980(pos).method_11654(property)));
        }
        helper.method_36036();
    }

    @class_6302(method_35936="botania:item/astrolabe_mana")
    public void testNotEnoughMana(class_4516 helper) {
        class_1657 player = this.mockAstrolabeAndUseWithCobbleRod(helper, 15000);
        this.checkRemainingMana(player, 15000);
        helper.method_35998(blockPos -> helper.method_36012(class_2246.field_10445, blockPos));
        helper.method_36036();
    }

    @class_6302(method_35936="botania:item/astrolabe_mana")
    public void testBarelyNotEnoughMana(class_4516 helper) {
        class_1657 player = this.mockAstrolabeAndUseWithCobbleRod(helper, 19910);
        int expectedMana = 40;
        this.checkRemainingMana(player, 40);
        int expectedNumberOfBlocks = 109;
        MutableInt actualNumberOfBlocks = new MutableInt();
        helper.method_35998(blockPos -> {
            if (helper.method_35980(blockPos).method_27852(class_2246.field_10445)) {
                actualNumberOfBlocks.increment();
            }
        });
        TestingUtil.assertEquals(109, actualNumberOfBlocks.intValue(), () -> String.format("Expected %d placed blocks, found %d", 109, actualNumberOfBlocks.intValue()));
        helper.method_36036();
    }

    private class_1657 mockAstrolabeAndUseWithCobbleRod(class_4516 helper, int mana) {
        class_1657 player = this.mockPlayerWithAstrolabe(helper, POS_PLAYER_MANA, POS_PLAYER_MANA, mana);
        player.method_7270(new class_1799((class_1935)BotaniaItems.cobbleRod));
        class_1799 stack = this.getAstrolabeForBlockType(player, class_2246.field_10445);
        AstrolabeItem.setSize(stack, 11);
        this.useAstrolabe(player, stack, class_1268.field_5808);
        return player;
    }

    private void useAstrolabe(class_1657 player, class_1799 stack, class_1268 hand) {
        class_3965 hitResult = ToolCommons.raytraceFromEntity((class_1297)player, 5.0, true);
        class_1838 useOnContext = new class_1838(player, hand, hitResult);
        stack.method_7981(useOnContext);
    }

    private void checkRemainingMana(class_1657 player, int expectedMana) {
        class_1799 tablet = player.method_31548().method_5438(1);
        ManaItem manaItem = XplatAbstractions.INSTANCE.findManaItem(tablet);
        TestingUtil.assertThat(manaItem != null, () -> "Missing mana tablet");
        TestingUtil.assertEquals(expectedMana, manaItem.getMana(), () -> String.format("Expected %d remaining mana, but found %d", expectedMana, manaItem.getMana()));
    }

    @NotNull
    private class_1657 mockPlayerWithAstrolabe(class_4516 helper, class_243 posPlayer, class_243 lookTarget, int mana) {
        class_1657 player = helper.method_36021();
        player.method_6122(class_1268.field_5808, new class_1799((class_1935)BotaniaItems.astrolabe));
        class_1799 tablet = new class_1799((class_1935)BotaniaItems.manaTablet);
        Objects.requireNonNull(XplatAbstractions.INSTANCE.findManaItem(tablet)).addMana(mana);
        player.method_31548().method_7394(tablet);
        player.method_33574(helper.method_35978(posPlayer));
        class_243 targetVec = helper.method_35978(lookTarget);
        player.method_5702(class_2183.class_2184.field_9851, targetVec);
        return player;
    }

    @NotNull
    private class_1799 getAstrolabeForBlockType(class_1657 player, class_2248 block) {
        class_1799 stack = player.method_5998(class_1268.field_5808);
        AstrolabeItem.setBlock(stack, block.method_9564());
        return stack;
    }
}

