/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block;

import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5819;
import vazkii.botania.client.fx.SparkleParticleData;

public class BotaniaGrassBlock extends BotaniaBlock {

	public enum Variant {
		DRY,
		GOLDEN,
		VIVID,
		SCORCHED,
		INFUSED,
		MUTATED
	}

	private final Variant variant;

	public BotaniaGrassBlock(Variant v, class_2251 builder) {
		super(builder);
		this.variant = v;
	}

	@Override
	public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 rand) {
		if (!world.field_9236 && state.method_27852(this) && world.method_22339(pos.method_10084()) >= 9) {
			for (int l = 0; l < 4; ++l) {
				class_2338 pos1 = pos.method_10069(rand.method_43048(3) - 1, rand.method_43048(5) - 3, rand.method_43048(3) - 1);
				class_2338 pos1up = pos1.method_10084();

				if (world.method_8320(pos1).method_27852(class_2246.field_10566) && world.method_22339(pos1up) >= 4 && world.method_8320(pos1up).method_26193(world, pos1up) <= 2) {
					world.method_8501(pos1, method_9564());
				}
			}
		}
	}

	@Override
	public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 r) {
		switch (variant) {
			case DRY:
				break;
			case GOLDEN:
				break;
			case VIVID:
				break;
			case SCORCHED:
				if (r.method_43048(80) == 0) {
					world.method_8406(class_2398.field_11240, pos.method_10263() + r.method_43057(), pos.method_10264() + 1.1, pos.method_10260() + r.method_43057(), 0, 0, 0);
				}
				break;
			case INFUSED:
				if (r.method_43048(100) == 0) {
					SparkleParticleData data = SparkleParticleData.sparkle(r.method_43057() * 0.2F + 1F, 0F, 1F, 1F, 5);
					world.method_8406(data, pos.method_10263() + r.method_43057(), pos.method_10264() + 1.05, pos.method_10260() + r.method_43057(), 0, 0, 0);
				}
				break;
			case MUTATED:
				if (r.method_43048(100) == 0) {
					if (r.method_43048(100) > 25) {
						SparkleParticleData data = SparkleParticleData.sparkle(r.method_43057() * 0.2F + 1F, 1F, 0F, 1F, 5);
						world.method_8406(data, pos.method_10263() + r.method_43057(), pos.method_10264() + 1.05, pos.method_10260() + r.method_43057(), 0, 0, 0);
					} else {
						SparkleParticleData data = SparkleParticleData.sparkle(r.method_43057() * 0.2F + 1F, 1F, 1F, 0F, 5);
						world.method_8406(data, pos.method_10263() + r.method_43057(), pos.method_10264() + 1.05, pos.method_10260() + r.method_43057(), 0, 0, 0);
					}
				}
				break;
		}
	}
}
