/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.render.block_entity;

import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.api.block_entity.SpecialFlowerBlockEntity;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.item.WandOfTheForestItem;
import vazkii.botania.common.item.equipment.bauble.ManaseerMonocleItem;

public class SpecialFlowerBlockEntityRenderer<T extends SpecialFlowerBlockEntity> implements class_827<T> {

	public static final int INNER_ALPHA = 32;
	public static final int OUTER_ALPHA = 64;
	public static final float FRAME_WIDTH = 1F / 16F;
	public static final float Y_OFFSET_INNER = 1F / 16F;
	public static final float Y_OFFSET_OUTER = FRAME_WIDTH + FRAME_WIDTH / 4F;
	public static final int TOTAL_ANGLES = 360;
	public static final double DEGREES_TO_RADIAN = (Math.PI / (double) (TOTAL_ANGLES / 2));

	public SpecialFlowerBlockEntityRenderer(class_5614.class_5615 ctx) {}

	@Override
	public void render(SpecialFlowerBlockEntity tile, float partialTicks, class_4587 ms, class_4597 buffers, int light, int overlay) {
		if (tile.isFloating()) {
			FloatingFlowerBlockEntityRenderer.renderFloatingIsland(tile, partialTicks, ms, buffers, overlay);
		}
		if (!(class_310.method_1551().field_1719 instanceof class_1309 view)) {
			return;
		}

		if (!ManaseerMonocleItem.hasMonocle(view)) {
			return;
		}
		class_2338 pos = null;
		class_239 ray = class_310.method_1551().field_1765;
		if (ray != null && ray.method_17783() == class_239.class_240.field_1332) {
			pos = ((class_3965) ray).method_17777();
		}
		boolean hasBindingAttempt = hasBindingAttempt(view, tile.method_11016());

		if (hasBindingAttempt || tile.method_11016().equals(pos)) {
			SpecialFlowerBlockEntity flower = tile;
			ms.method_22903();
			if (hasBindingAttempt) {
				ms.method_22904(0, 0.005, 0);
			}
			renderRadius(tile, ms, buffers, flower.getRadius());
			ms.method_22904(0, 0.002, 0);
			renderRadius(tile, ms, buffers, flower.getSecondaryRadius());
			ms.method_22909();

		}
	}

	public static void renderRadius(class_2586 tile, class_4587 ms, class_4597 buffers, @Nullable RadiusDescriptor descriptor) {
		if (descriptor != null) {
			ms.method_22903();
			ms.method_22904(0, RenderHelper.getOffY(), 0);
			if (descriptor instanceof RadiusDescriptor.Circle circle) {
				renderCircle(ms, buffers, tile.method_11016(), circle.subtileCoords(), circle.radius());
			} else if (descriptor instanceof RadiusDescriptor.Rectangle rectangle) {
				renderRectangle(ms, buffers, tile.method_11016(), rectangle.aabb());
			}
			RenderHelper.incrementOffY();
			ms.method_22909();
		}
	}

	public static boolean hasBindingAttempt(class_1309 view, class_2338 tilePos) {
		class_1799 stackHeld = PlayerHelper.getFirstHeldItemClass(view, WandOfTheForestItem.class);
		if (!stackHeld.method_7960() && WandOfTheForestItem.getBindMode(stackHeld)) {
			return WandOfTheForestItem.getBindingAttempt(stackHeld).filter(tilePos::equals).isPresent();
		}
		return false;
	}

	public static void renderCircle(class_4587 ms, class_4597 buffers, class_2338 tilePos, class_2338 center, double radius) {
		ms.method_22903();
		ms.method_22904(center.method_10263() - tilePos.method_10263() + 0.5, center.method_10264() - tilePos.method_10264(), center.method_10260() - tilePos.method_10260() + 0.5);

		int color = class_3532.method_15369(ClientTickHandler.ticksInGame % 200 / 200F, 0.6F, 1F);
		int r = (color >> 16 & 0xFF);
		int g = (color >> 8 & 0xFF);
		int b = (color & 0xFF);

		class_4588 buffer = buffers.getBuffer(RenderHelper.CIRCLE);
		Matrix4f mat = ms.method_23760().method_23761();

		double innerRadius = radius - FRAME_WIDTH;
		Runnable centerFuncInner = () -> buffer.method_22918(mat, 0, Y_OFFSET_INNER, 0).method_1336(r, g, b, INNER_ALPHA).method_1344();
		Runnable centerFuncOuter = () -> buffer.method_22918(mat, 0, Y_OFFSET_OUTER, 0).method_1336(r, g, b, OUTER_ALPHA).method_1344();
		Runnable[] vertexFuncsInner = new Runnable[TOTAL_ANGLES + 1];
		Runnable[] vertexFuncsOuter = new Runnable[TOTAL_ANGLES + 1];

		for (int i = 0; i < TOTAL_ANGLES; i++) {
			double rad = (TOTAL_ANGLES - i) * DEGREES_TO_RADIAN;
			double cos = Math.cos(rad);
			double sin = Math.sin(rad);

			float xpInner = (float) (cos * innerRadius);
			float zpInner = (float) (sin * innerRadius);
			vertexFuncsInner[i] = (() -> buffer.method_22918(mat, xpInner, Y_OFFSET_INNER, zpInner).method_1336(r, g, b, INNER_ALPHA).method_1344());

			float xpOuter = (float) (Math.cos(rad) * radius);
			float zpOuter = (float) (Math.sin(rad) * radius);
			vertexFuncsOuter[i] = (() -> buffer.method_22918(mat, xpOuter, Y_OFFSET_OUTER, zpOuter).method_1336(r, g, b, OUTER_ALPHA).method_1344());
		}
		vertexFuncsInner[TOTAL_ANGLES] = vertexFuncsInner[0];
		vertexFuncsOuter[TOTAL_ANGLES] = vertexFuncsOuter[0];

		RenderHelper.triangleFan(centerFuncInner, vertexFuncsInner);
		RenderHelper.triangleFan(centerFuncOuter, vertexFuncsOuter);

		ms.method_22909();
	}

	public static void renderRectangle(class_4587 ms, class_4597 buffers, class_2338 tilePos, class_238 aabb) {
		ms.method_22903();
		ms.method_22904(aabb.field_1323 - tilePos.method_10263(), aabb.field_1322 - tilePos.method_10264(), aabb.field_1321 - tilePos.method_10260());

		int color = class_3532.method_15369(ClientTickHandler.ticksInGame % 200 / 200F, 0.6F, 1F);
		int r = (color >> 16 & 0xFF);
		int g = (color >> 8 & 0xFF);
		int b = (color & 0xFF);

		float xSize = (float) aabb.method_17939();
		float zSize = (float) aabb.method_17941();
		float xSizeInner = xSize - FRAME_WIDTH;
		float zSizeInner = zSize - FRAME_WIDTH;

		class_4588 buffer = buffers.getBuffer(RenderHelper.RECTANGLE);
		Matrix4f mat = ms.method_23760().method_23761();
		RenderHelper.flatRectangle(buffer, mat, FRAME_WIDTH, xSizeInner, Y_OFFSET_INNER, FRAME_WIDTH, zSizeInner,
				r, g, b, INNER_ALPHA);
		RenderHelper.flatRectangle(buffer, mat, 0, xSize, Y_OFFSET_OUTER, 0, zSize, r, g, b, OUTER_ALPHA);

		ms.method_22909();
	}

}
