package vazkii.botania.client.integration.emi;

import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.recipe.OrechidRecipe;
import vazkii.botania.client.integration.shared.OrechidUIHelper;

import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2561;
import net.minecraft.class_5684;

public class OrechidEmiRecipe extends BotaniaEmiRecipe {
	private final EmiIngredient orechid;
	protected final OrechidRecipe recipe;

	public OrechidEmiRecipe(EmiRecipeCategory category, OrechidRecipe recipe, EmiIngredient orechid) {
		super(category, recipe);
		try {
			this.input = recipe.getInput().getDisplayed().stream()
					.map(s -> EmiIngredient.of(class_1856.method_8091(s.method_26204()), 1)).toList();
			this.output = recipe.getOutput().getDisplayed().stream()
					.map(s -> EmiStack.of(new class_1799(s.method_26204()))).toList();
		} catch (Throwable e) {
			throw new RuntimeException(e);
		}
		this.orechid = orechid;
		this.recipe = recipe;
	}

	@Override
	public int getDisplayHeight() {
		return 44;
	}

	@Override
	public int getDisplayWidth() {
		return 96;
	}

	@Override
	public boolean supportsRecipeTree() {
		return false;
	}

	@Override
	public void addWidgets(WidgetHolder widgets) {
		PureDaisyEmiRecipe.addPureDaisyWidgets(widgets, this, input.get(0), orechid, output.get(0));

		final Double chance = getChance(recipe);
		if (chance != null) {
			final class_2561 chanceComponent = OrechidUIHelper.getPercentageComponent(chance);
			widgets.add(new TextWidget(chanceComponent.method_30937(), 90, 3, 0x555555, false) {
				@Override
				public List<class_5684> getTooltip(int mouseX, int mouseY) {
					return getChanceTooltipComponents(chance)
							.map(class_2561::method_30937)
							.map(class_5684::method_32662)
							.toList();
				}
			}.horizontalAlign(TextWidget.Alignment.END));
		}
	}

	@NotNull
	protected Stream<class_2561> getChanceTooltipComponents(double chance) {
		final var ratio = OrechidUIHelper.getRatioForChance(chance);
		return Stream.of(OrechidUIHelper.getRatioTooltipComponent(ratio));
	}

	@Nullable
	protected Double getChance(@NotNull OrechidRecipe recipe) {
		return OrechidUIHelper.getChance(recipe, null);
	}

	public int getWeight() {
		return recipe.getWeight();
	}
}
