/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.relic;

import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.item.Relic;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.entity.BabylonWeaponEntity;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.helper.VecHelper;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_5328;
import net.minecraft.class_5819;

public class KeyOfTheKingsLawItem extends RelicItem {

	private static final String TAG_WEAPONS_SPAWNED = "weaponsSpawned";
	private static final String TAG_CHARGING = "charging";

	public static final int WEAPON_TYPES = 12;

	public KeyOfTheKingsLawItem(class_1793 props) {
		super(props);
	}

	@NotNull
	@Override
	public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, @NotNull class_1268 hand) {
		class_1799 stack = player.method_5998(hand);
		setCharging(stack, true);
		return class_5328.method_29282(world, player, hand);
	}

	@Override
	public void method_7840(class_1799 stack, class_1937 world, class_1309 living, int time) {
		int spawned = getWeaponsSpawned(stack);
		if (spawned == 20) {
			setCharging(stack, false);
			setWeaponsSpawned(stack, 0);
		}
	}

	@Override
	public void method_7852(class_1937 world, class_1309 living, class_1799 stack, int count) {
		int spawned = getWeaponsSpawned(stack);

		if (count != method_7881(stack) && spawned < 20 && !world.field_9236 && (!(living instanceof class_1657 player) || ManaItemHandler.instance().requestManaExact(stack, player, 150, true))) {
			class_243 look = living.method_5720().method_18805(1, 0, 1);

			double playerRot = Math.toRadians(living.method_36454() + 90);
			if (look.field_1352 == 0 && look.field_1350 == 0) {
				look = new class_243(Math.cos(playerRot), 0, Math.sin(playerRot));
			}

			look = look.method_1029().method_1021(-2);

			int div = spawned / 5;
			int mod = spawned % 5;

			class_243 pl = look.method_1019(VecHelper.fromEntityCenter(living)).method_1031(0, 1.6, div * 0.1);

			var rand = world.field_9229;
			class_243 axis = look.method_1029().method_1036(new class_243(-1, 0, -1)).method_1029();

			double rot = mod * Math.PI / 4 - Math.PI / 2;

			class_243 axis1 = VecHelper.rotate(axis.method_1021(div * 3.5 + 5), rot, look);
			if (axis1.field_1351 < 0) {
				axis1 = axis1.method_18805(1, -1, 1);
			}

			class_243 end = pl.method_1019(axis1);

			BabylonWeaponEntity weapon = new BabylonWeaponEntity(living, world);
			weapon.method_5814(end.field_1352, end.field_1351, end.field_1350);
			weapon.method_36456(living.method_36454());
			weapon.setVariety(rand.method_43048(WEAPON_TYPES));
			weapon.setDelay(spawned);
			weapon.setRotation(class_3532.method_15393(-living.method_36454() + 180));

			world.method_8649(weapon);
			weapon.method_5783(BotaniaSounds.babylonSpawn, 1F, 1F + world.field_9229.method_43057() * 3F);
			setWeaponsSpawned(stack, spawned + 1);
		}
	}

	@NotNull
	@Override
	public class_1839 method_7853(class_1799 stack) {
		return class_1839.field_8953;
	}

	@Override
	public int method_7881(class_1799 stack) {
		return 72000;
	}

	public static boolean isCharging(class_1799 stack) {
		return ItemNBTHelper.getBoolean(stack, TAG_CHARGING, false);
	}

	public static int getWeaponsSpawned(class_1799 stack) {
		return ItemNBTHelper.getInt(stack, TAG_WEAPONS_SPAWNED, 0);
	}

	public static void setCharging(class_1799 stack, boolean charging) {
		ItemNBTHelper.setBoolean(stack, TAG_CHARGING, charging);
	}

	public static void setWeaponsSpawned(class_1799 stack, int count) {
		ItemNBTHelper.setInt(stack, TAG_WEAPONS_SPAWNED, count);
	}

	public static Relic makeRelic(class_1799 stack) {
		return new RelicImpl(stack, prefix("challenge/king_key"));
	}
}
