/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.lens;

import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2680;
import net.minecraft.class_3965;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.helper.ForcePushHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.mixin.PistonBaseBlockAccessor;

public class ForceLens extends Lens {

	@Override
	public boolean collideBurst(ManaBurst burst, class_239 pos, boolean isManaBlock, boolean shouldKill, class_1799 stack) {
		class_1297 entity = burst.entity();
		if (pos.method_17783() == class_239.class_240.field_1332
				&& !burst.isFake()
				&& !isManaBlock) {
			class_3965 rtr = (class_3965) pos;
			class_2680 state = entity.method_37908().method_8320(rtr.method_17777());
			class_1799 sourceLens = burst.getSourceLens();
			boolean isWarp = sourceLens.method_31574(BotaniaItems.lensWarp);
			if (isWarp && state.method_27852(BotaniaBlocks.pistonRelay)) {
				// warp+force should not move the force relay
				return false;
			}

			// mana burst could have been warped here, so don't assume that any block is unmovable
			moveBlocks(entity.method_37908(), rtr.method_17777().method_10093(rtr.method_17780()), rtr.method_17780().method_10153(), ManaBurst.NO_SOURCE);
		}

		return shouldKill;
	}

	/**
	 * Executes a force-push of blocks without an actual piston being present.
	 * 
	 * @param level            The level.
	 * @param impliedPistonPos Position where to push block from.
	 * @param direction        Direction to move block towards from the impliedPistonPos.
	 * @param pushSourcePos    Position of the push source. The block at this position is considered unmovable,
	 *                         and usually it would be the pushing piston.
	 * @return {@code true} if blocks have started moving, or {@code false} if moving blocks failed,
	 *         e.g. due to exceeded push limit or unmovable blocks being in the way.
	 */
	@SuppressWarnings("try")
	public static boolean moveBlocks(class_1937 level, class_2338 impliedPistonPos, class_2350 direction, class_2338 pushSourcePos) {
		try (var ignored = new ForcePushHelper(pushSourcePos)) {
			return ((PistonBaseBlockAccessor) class_2246.field_10560).botania_moveBlocks(level, impliedPistonPos, direction, true);
		}
	}

}
