/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.armor.elementium;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.common.handler.PixieHandler;

public class ElementiumLegsItem extends ElementiumArmorItem {

	public ElementiumLegsItem(class_1793 props) {
		super(class_8051.field_41936, props);
	}

	@NotNull
	@Override
	public Multimap<class_1320, class_1322> method_7844(@NotNull class_1304 slot) {
		Multimap<class_1320, class_1322> ret = super.method_7844(slot);
		if (slot == method_7685()) {
			ret = HashMultimap.create(ret);
			ret.put(PixieHandler.PIXIE_SPAWN_CHANCE, PixieHandler.makeModifier(slot, "Armor modifier", 0.15));
		}
		return ret;
	}

}
