/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.crafting.recipe;

import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_7710;
import net.minecraft.class_8566;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.mana.BasicLensItem;

public class SplitLensRecipe extends class_1852 {
	public static final NoOpRecipeSerializer<SplitLensRecipe> SERIALIZER = new NoOpRecipeSerializer<>(SplitLensRecipe::new);

	public SplitLensRecipe(class_2960 id) {
		super(id, class_7710.field_40249);
	}

	@Override
	public boolean matches(@NotNull class_8566 inv, @NotNull class_1937 level) {
		return !assemble(inv, level.method_30349()).method_7960();
	}

	@NotNull
	@Override
	public class_1799 assemble(class_8566 inv, @NotNull class_5455 registries) {
		class_1799 found = class_1799.field_8037;
		for (int i = 0; i < inv.method_5439(); i++) {
			class_1799 candidate = inv.method_5438(i);
			if (candidate.method_7960()) {
				continue;
			}
			if (!found.method_7960() || (found = getComposite(candidate)).method_7960()) {
				return class_1799.field_8037;
			}
		}
		if (!found.method_7960()) {
			found = found.method_46651(1);
		}
		return found;
	}

	private class_1799 getComposite(class_1799 stack) {
		class_1792 item = stack.method_7909();
		if (!(item instanceof BasicLensItem basicLens)) {
			return class_1799.field_8037;
		}
		return basicLens.getCompositeLens(stack);
	}

	@NotNull
	@Override
	public class_2371<class_1799> getRemainingItems(class_8566 inv) {
		class_2371<class_1799> remaining = class_2371.method_10213(inv.method_5439(), class_1799.field_8037);
		for (int i = 0; i < inv.method_5439(); i++) {
			class_1799 candidate = inv.method_5438(i);
			if (candidate.method_7909() instanceof BasicLensItem basicLensItem) {
				class_1799 newLens = candidate.method_46651(1);
				basicLensItem.setCompositeLens(newLens, class_1799.field_8037);
				remaining.set(i, newLens);
			}
		}
		return remaining;
	}

	@Override
	public boolean method_8113(int width, int height) {
		return width * height >= 1;
	}

	@NotNull
	@Override
	public class_1865<?> method_8119() {
		return SERIALIZER;
	}
}
