/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.corporea.CorporeaHelper;
import vazkii.botania.common.entity.BotaniaEntities;
import vazkii.botania.common.entity.CorporeaSparkEntity;
import vazkii.botania.common.impl.corporea.DummyCorporeaNode;
import vazkii.botania.common.lib.BotaniaTags;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;

public class CorporeaSparkItem extends class_1792 {

	public CorporeaSparkItem(class_1793 props) {
		super(props);
	}

	@NotNull
	@Override
	public class_1269 method_7884(class_1838 ctx) {
		return attachSpark(ctx.method_8045(), ctx.method_8037(), ctx.method_8041())
				? class_1269.method_29236(ctx.method_8045().method_8608())
				: class_1269.field_5811;
	}

	private static boolean canPlace(class_1937 world, CorporeaSparkEntity spark) {
		return world.method_8320(spark.getAttachPos()).method_26164(BotaniaTags.Blocks.CORPOREA_SPARK_OVERRIDE)
				|| !(spark.getSparkNode() instanceof DummyCorporeaNode);
	}

	public static boolean attachSpark(class_1937 world, class_2338 pos, class_1799 stack) {
		CorporeaSparkEntity spark = BotaniaEntities.CORPOREA_SPARK.method_5883(world);
		if (stack.method_31574(BotaniaItems.corporeaSparkMaster)) {
			spark.setMaster(true);
		}
		if (stack.method_31574(BotaniaItems.corporeaSparkCreative)) {
			spark.setCreative(true);
		}
		spark.method_5814(pos.method_10263() + 0.5, pos.method_10264() + 1.25, pos.method_10260() + 0.5);

		if (canPlace(world, spark) && !CorporeaHelper.instance().doesBlockHaveSpark(world, pos)) {
			if (!world.field_9236) {
				world.method_8649(spark);
				stack.method_7934(1);
			}
			return true;
		}
		return false;
	}

	@Override
	public void method_7851(class_1799 stack, @Nullable class_1937 level, List<class_2561> tooltip, class_1836 tooltipFlag) {
		if (stack.method_31574(BotaniaItems.corporeaSparkCreative)) {
			tooltip.add(class_2561.method_43471("botaniamisc.creativeSpark").method_27692(class_124.field_1080));
		}
	}
}
