/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.block_entity.corporea;

import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.block.WandHUD;
import vazkii.botania.api.block.Wandable;
import vazkii.botania.api.corporea.*;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntity;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class CorporeaRetainerBlockEntity extends BotaniaBlockEntity implements Wandable {
	private static final String TAG_REQUEST_X = "requestX";
	private static final String TAG_REQUEST_Y = "requestY";
	private static final String TAG_REQUEST_Z = "requestZ";
	private static final String TAG_REQUEST_TYPE = "requestType";
	private static final String TAG_REQUEST_COUNT = "requestCount";
	private static final String TAG_RETAIN_MISSING = "retainMissing";

	private static final Map<class_2960, Function<class_2487, ? extends CorporeaRequestMatcher>> corporeaMatcherDeserializers = new ConcurrentHashMap<>();
	private static final Map<Class<? extends CorporeaRequestMatcher>, class_2960> corporeaMatcherSerializers = new ConcurrentHashMap<>();

	private class_2338 requestPos = ManaBurst.NO_SOURCE;

	@Nullable
	private CorporeaRequestMatcher request;
	private int requestCount;
	private boolean retainMissing = false;

	public CorporeaRetainerBlockEntity(class_2338 pos, class_2680 state) {
		super(BotaniaBlockEntities.CORPOREA_RETAINER, pos, state);
	}

	public void remember(class_2338 pos, CorporeaRequestMatcher request, int count, int missing) {
		this.requestPos = pos;
		this.request = request;
		this.requestCount = retainMissing ? missing : count;

		method_5431();
	}

	public void forget() {
		request = null;
		requestCount = 0;
	}

	public int getComparatorValue() {
		return CorporeaHelper.instance().signalStrengthForRequestSize(requestCount);
	}

	public boolean hasPendingRequest() {
		return request != null;
	}

	public void fulfilRequest() {
		if (!hasPendingRequest()) {
			return;
		}

		CorporeaSpark spark = CorporeaHelper.instance().getSparkForBlock(field_11863, requestPos);
		if (spark != null) {
			class_2586 te = spark.getSparkNode().getWorld().method_8321(spark.getSparkNode().getPos());
			if (te instanceof CorporeaRequestor requestor) {
				requestor.doCorporeaRequest(request, requestCount, spark, null);

				forget();
				method_5431();
			}
		}
	}

	@Override
	public void writePacketNBT(class_2487 cmp) {
		super.writePacketNBT(cmp);

		cmp.method_10569(TAG_REQUEST_X, requestPos.method_10263());
		cmp.method_10569(TAG_REQUEST_Y, requestPos.method_10264());
		cmp.method_10569(TAG_REQUEST_Z, requestPos.method_10260());

		class_2960 reqType = request != null ? corporeaMatcherSerializers.get(request.getClass()) : null;

		if (reqType != null) {
			cmp.method_10582(TAG_REQUEST_TYPE, reqType.toString());
			request.writeToNBT(cmp);
			cmp.method_10569(TAG_REQUEST_COUNT, requestCount);
		}
		cmp.method_10556(TAG_RETAIN_MISSING, retainMissing);
	}

	@Override
	public void readPacketNBT(class_2487 cmp) {
		super.readPacketNBT(cmp);

		int x = cmp.method_10550(TAG_REQUEST_X);
		int y = cmp.method_10550(TAG_REQUEST_Y);
		int z = cmp.method_10550(TAG_REQUEST_Z);
		requestPos = new class_2338(x, y, z);

		class_2960 reqType = class_2960.method_12829(cmp.method_10558(TAG_REQUEST_TYPE));
		if (reqType != null && corporeaMatcherDeserializers.containsKey(reqType)) {
			request = corporeaMatcherDeserializers.get(reqType).apply(cmp);
		} else {
			request = null;
		}
		requestCount = cmp.method_10550(TAG_REQUEST_COUNT);
		retainMissing = cmp.method_10577(TAG_RETAIN_MISSING);
	}

	public static <T extends CorporeaRequestMatcher> void addCorporeaRequestMatcher(class_2960 id, Class<T> clazz, Function<class_2487, T> deserializer) {
		corporeaMatcherSerializers.put(clazz, id);
		corporeaMatcherDeserializers.put(id, deserializer);
	}

	public static class WandHud implements WandHUD {
		private final CorporeaRetainerBlockEntity retainer;

		public WandHud(CorporeaRetainerBlockEntity retainer) {
			this.retainer = retainer;
		}

		@Override
		public void renderHUD(class_332 gui, class_310 mc) {
			String mode = class_1074.method_4662("botaniamisc.retainer." + (retainer.retainMissing ? "retain_missing" : "retain_all"));
			int strWidth = mc.field_1772.method_1727(mode);
			int x = (mc.method_22683().method_4486() - strWidth) / 2;
			int y = mc.method_22683().method_4502() / 2 + 8;

			RenderHelper.renderHUDBox(gui, x - 2, y, x + strWidth + 2, y + 12);
			gui.method_25303(mc.field_1772, mode, x, y + 2, class_124.field_1068.method_532());
		}
	}

	@Override
	public boolean onUsedByWand(class_1657 player, class_1799 stack, class_2350 side) {
		if (!field_11863.field_9236) {
			retainMissing = !retainMissing;
			method_5431();
			VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
		}
		return true;
	}
}
