/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.gui.box;

import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.client.gui.SlotLocked;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.BaubleBoxItem;
import vazkii.botania.common.item.BotaniaItems;

public class BaubleBoxContainer extends class_1703 {
	public static BaubleBoxContainer fromNetwork(int windowId, class_1661 inv, class_2540 buf) {
		class_1268 hand = buf.readBoolean() ? class_1268.field_5808 : class_1268.field_5810;
		return new BaubleBoxContainer(windowId, inv, inv.field_7546.method_5998(hand));
	}

	private final class_1799 box;

	public BaubleBoxContainer(int windowId, class_1661 playerInv, class_1799 box) {
		super(BotaniaItems.BAUBLE_BOX_CONTAINER, windowId);
		int i;
		int j;

		this.box = box;
		class_1263 baubleBoxInv;
		if (!playerInv.field_7546.method_37908().field_9236) {
			baubleBoxInv = BaubleBoxItem.getInventory(box);
		} else {
			baubleBoxInv = new class_1277(BaubleBoxItem.SIZE);
		}

		for (i = 0; i < 4; ++i) {
			for (j = 0; j < 6; ++j) {
				int k = j + i * 6;
				method_7621(new class_1735(baubleBoxInv, k, 62 + j * 18, 8 + i * 18) {
					@Override
					public boolean method_7680(@NotNull class_1799 stack) {
						return EquipmentHandler.instance.isAccessory(stack);
					}
				});
			}
		}

		for (i = 0; i < 3; ++i) {
			for (j = 0; j < 9; ++j) {
				method_7621(new class_1735(playerInv, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
			}
		}

		for (i = 0; i < 9; ++i) {
			if (playerInv.method_5438(i) == box) {
				method_7621(new SlotLocked(playerInv, i, 8 + i * 18, 142));
			} else {
				method_7621(new class_1735(playerInv, i, 8 + i * 18, 142));
			}
		}

	}

	@Override
	public boolean method_7597(@NotNull class_1657 player) {
		class_1799 main = player.method_6047();
		class_1799 off = player.method_6079();
		return !main.method_7960() && main == box || !off.method_7960() && off == box;
	}

	@NotNull
	@Override
	public class_1799 method_7601(class_1657 player, int slotIndex) {
		class_1799 itemstack = class_1799.field_8037;
		class_1735 slot = field_7761.get(slotIndex);

		if (slot != null && slot.method_7681()) {
			class_1799 itemstack1 = slot.method_7677();
			itemstack = itemstack1.method_7972();

			int boxStart = 0;
			int boxEnd = boxStart + 24;
			int invEnd = boxEnd + 36;

			if (slotIndex < boxEnd) {
				if (!method_7616(itemstack1, boxEnd, invEnd, true)) {
					return class_1799.field_8037;
				}
			} else {
				if (!itemstack1.method_7960() && EquipmentHandler.instance.isAccessory(itemstack1) && !method_7616(itemstack1, boxStart, boxEnd, false)) {
					return class_1799.field_8037;
				}
			}

			if (itemstack1.method_7960()) {
				slot.method_7673(class_1799.field_8037);
			} else {
				slot.method_7668();
			}

			if (itemstack1.method_7947() == itemstack.method_7947()) {
				return class_1799.field_8037;
			}

			slot.method_7667(player, itemstack1);
		}

		return itemstack;
	}

	@Override
	public void method_7595(@NotNull class_1657 player) {
		if (!player.method_37908().field_9236) {
			ItemNBTHelper.setBoolean(box, BaubleBoxItem.TAG_OPEN, false);
		}
		super.method_7595(player);
	}
}
