/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.api.block_entity;

import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.internal.ManaNetwork;
import vazkii.botania.api.mana.ManaPool;

/**
 * The basic class for a Functional Flower.
 */
public abstract class FunctionalFlowerBlockEntity extends BindableSpecialFlowerBlockEntity<ManaPool> {
	private static final class_2960 POOL_ID = new class_2960(BotaniaAPI.MODID, "mana_pool");

	public static final int LINK_RANGE = 10;
	private static final String TAG_MANA = "mana";

	private int mana;
	public int redstoneSignal = 0;

	public FunctionalFlowerBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
		super(type, pos, state, ManaPool.class);
	}

	/**
	 * If set to true, redstoneSignal will be updated every tick.
	 */
	public boolean acceptsRedstone() {
		return false;
	}

	@Override
	public void tickFlower() {
		super.tickFlower();

		drawManaFromPool();

		redstoneSignal = 0;
		if (acceptsRedstone()) {
			for (class_2350 dir : class_2350.values()) {
				int redstoneSide = method_10997().method_49808(method_11016().method_10093(dir), dir);
				redstoneSignal = Math.max(redstoneSignal, redstoneSide);
			}
		}

		if (method_10997().field_9236) {
			double particleChance = 1F - (double) mana / (double) getMaxMana() / 3.5F;
			int color = getColor();
			float red = (color >> 16 & 0xFF) / 255F;
			float green = (color >> 8 & 0xFF) / 255F;
			float blue = (color & 0xFF) / 255F;
			if (Math.random() > particleChance) {
				BotaniaAPI.instance().sparkleFX(method_10997(), method_11016().method_10263() + 0.3 + Math.random() * 0.5, method_11016().method_10264() + 0.5 + Math.random() * 0.5, method_11016().method_10260() + 0.3 + Math.random() * 0.5, red, green, blue, (float) Math.random(), 5);
			}
		}
	}

	@Override
	public int getBindingRadius() {
		return LINK_RANGE;
	}

	@Nullable
	@Override
	public class_2338 findClosestTarget() {
		ManaNetwork network = BotaniaAPI.instance().getManaNetworkInstance();
		var closestPool = network.getClosestPool(method_11016(), method_10997(), getBindingRadius());
		return closestPool == null ? null : closestPool.getManaReceiverPos();
	}

	public void drawManaFromPool() {
		ManaPool pool = findBoundTile();
		if (pool != null) {
			int manaInPool = pool.getCurrentMana();
			int manaMissing = getMaxMana() - mana;
			int manaToRemove = Math.min(manaMissing, manaInPool);
			pool.receiveMana(-manaToRemove);
			addMana(manaToRemove);
		}
	}

	@Override
	public int getMana() {
		return mana;
	}

	@Override
	public void addMana(int mana) {
		this.mana = class_3532.method_15340(this.mana + mana, 0, getMaxMana());
		method_5431();
	}

	@Override
	public class_1799 getDefaultHudIcon() {
		return class_7923.field_41178.method_17966(POOL_ID).map(class_1799::new).orElse(class_1799.field_8037);
	}

	@Override
	public void readFromPacketNBT(class_2487 cmp) {
		super.readFromPacketNBT(cmp);
		mana = cmp.method_10550(TAG_MANA);
	}

	@Override
	public void writeToPacketNBT(class_2487 cmp) {
		super.writeToPacketNBT(cmp);
		cmp.method_10569(TAG_MANA, mana);
	}
}
