/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.test.block;

import net.minecraft.class_1299;
import net.minecraft.class_1533;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2609;
import net.minecraft.class_3962;
import net.minecraft.class_4513;
import net.minecraft.class_4516;
import net.minecraft.class_6302;
import vazkii.botania.test.TestingUtil;

public class HopperhockTest {

	private static final String TEMPLATE = "botania:block/hopperhock_furnace";
	private static final class_2338 FLOWER_POS = new class_2338(2, 3, 2);
	// Above the light gray glass which is at 2, 2, 1
	private static final class_2338 SPAWN_ITEM_POS = new class_2338(2, 3, 1);
	private static final float SPAWN_ITEM_X = SPAWN_ITEM_POS.method_10263();
	private static final float SPAWN_ITEM_Y = SPAWN_ITEM_POS.method_10264();
	private static final float SPAWN_ITEM_Z = SPAWN_ITEM_POS.method_10260();

	@class_6302(method_35936 = TEMPLATE)
	public void testFurnaceInsertTop(class_4516 helper) {
		var furnacePos = FLOWER_POS.method_10074();
		helper.method_35984(furnacePos, class_2246.field_10181);
		spawnItem(helper, class_1802.field_20412);

		helper.method_36018(() -> {
			assertItemInSlot(helper, furnacePos, 0, class_1802.field_20412, 1);
			helper.method_36004(class_1299.field_6052);
		});
	}

	@class_6302(method_35936 = TEMPLATE)
	public void testFurnaceInsertSide(class_4516 helper) {
		var furnacePos = FLOWER_POS.method_10072();
		helper.method_35984(furnacePos, class_2246.field_10181);
		spawnItem(helper, class_1802.field_8665);

		helper.method_36018(() -> {
			assertItemInSlot(helper, furnacePos, 1, class_1802.field_8665, 1);
			helper.method_36004(class_1299.field_6052);
		});
	}

	@class_6302(method_35936 = TEMPLATE)
	public void testFurnaceInsertBottom(class_4516 helper) {
		var furnacePos = FLOWER_POS.method_10084();
		helper.method_35984(furnacePos, class_2246.field_10181);
		spawnItem(helper, class_1802.field_8665);

		helper.method_36018(() -> {
			// Both the fuel and output slots are accessible from the bottom face, but inserting into the
			// output slot isn't possible.
			assertItemInSlot(helper, furnacePos, 1, class_1802.field_8665, 1);
			helper.method_36004(class_1299.field_6052);
		});
	}

	@class_6302(method_35936 = TEMPLATE)
	public void testFurnaceInventoryFull(class_4516 helper) {
		var furnacePos = FLOWER_POS.method_10074();
		helper.method_35984(furnacePos, class_2246.field_10181);
		getFurnaceBlockEntity(helper, furnacePos).method_5447(0, new class_1799(class_1802.field_8583, 64));
		spawnItem(helper, class_1802.field_8583);

		helper.method_36041().method_36077(61, () -> {
			assertItemInSlot(helper, furnacePos, 0, class_1802.field_8583, 64);
			helper.method_35969(class_1802.field_8583, SPAWN_ITEM_POS, 0);
		}).method_36075();
	}

	@class_6302(method_35936 = TEMPLATE)
	public void testFurnaceAddToStack(class_4516 helper) {
		var furnacePos = FLOWER_POS.method_10074();
		helper.method_35984(furnacePos, class_2246.field_10181);
		getFurnaceBlockEntity(helper, furnacePos).method_5447(0, new class_1799(class_1802.field_8583, 60));
		class_1542 itemEntity = spawnItem(helper, class_1802.field_8583);
		itemEntity.method_6983().method_7939(10);

		helper.method_36018(() -> {
			assertItemInSlot(helper, furnacePos, 0, class_1802.field_8583, 64);
			helper.method_35970(class_1802.field_8583, SPAWN_ITEM_POS, 0, 6);
		});
	}

	@class_6302(method_35936 = TEMPLATE)
	public void testFurnaceWrongItemForSlot(class_4516 helper) {
		var furnacePos = FLOWER_POS.method_10084();
		helper.method_35984(furnacePos, class_2246.field_10181);
		spawnItem(helper, class_1802.field_20390);

		helper.method_36041().method_36077(61, () -> {
			helper.method_36047(furnacePos);
			helper.method_35969(class_1802.field_20390, SPAWN_ITEM_POS, 0);
		}).method_36075();
	}

	@class_6302(method_35936 = TEMPLATE)
	public void testFurnaceFilterMatch(class_4516 helper) {
		var furnacePos = FLOWER_POS.method_10074();
		helper.method_35984(furnacePos, class_2246.field_10181);
		spawnItemFrame(helper, furnacePos.method_10067(), class_2350.field_11039, class_1802.field_20412);
		spawnItem(helper, class_1802.field_20412);

		helper.method_36018(() -> {
			assertItemInSlot(helper, furnacePos, 0, class_1802.field_20412, 1);
			helper.method_36004(class_1299.field_6052);
		});
	}

	@class_6302(method_35936 = TEMPLATE)
	public void testFurnaceFilterNoMatch(class_4516 helper) {
		var furnacePos = FLOWER_POS.method_10074();
		helper.method_35984(furnacePos, class_2246.field_10181);
		spawnItemFrame(helper, furnacePos.method_10067(), class_2350.field_11039, class_1802.field_8583);
		spawnItem(helper, class_1802.field_20412);

		helper.method_36041().method_36077(61, () -> {
			helper.method_36047(furnacePos);
			helper.method_35969(class_1802.field_20412, SPAWN_ITEM_POS, 0);
		}).method_36075();
	}

	@class_6302(method_35936 = TEMPLATE)
	public void testComposterInsertTop(class_4516 helper) {
		var composterPos = FLOWER_POS.method_10074();
		helper.method_35984(composterPos, class_2246.field_17563);
		spawnItem(helper, class_1802.field_8741);

		helper.method_36018(() -> {
			helper.method_35987(composterPos, class_3962.field_17565, 1);
			helper.method_36004(class_1299.field_6052);
		});
	}

	@class_6302(method_35936 = TEMPLATE)
	public void testComposterInsertSide(class_4516 helper) {
		var composterPos = FLOWER_POS.method_10072();
		spawnItemAndExpectNoPickUp(helper, composterPos, class_1802.field_8741);
	}

	@class_6302(method_35936 = TEMPLATE)
	public void testComposterInsertBottom(class_4516 helper) {
		var composterPos = FLOWER_POS.method_10084();
		spawnItemAndExpectNoPickUp(helper, composterPos, class_1802.field_8741);
	}

	@class_6302(method_35936 = TEMPLATE)
	public void testComposterInsertWrongItem(class_4516 helper) {
		var composterPos = FLOWER_POS.method_10074();
		spawnItemAndExpectNoPickUp(helper, composterPos, class_1802.field_8583);
	}

	@class_6302(method_35936 = TEMPLATE)
	public void testComposterFull(class_4516 helper) {
		var composterPos = FLOWER_POS.method_10074();
		helper.method_35986(composterPos, class_2246.field_17563.method_9564().method_11657(class_3962.field_17565, 7));
		spawnItem(helper, class_1802.field_8741);

		helper.method_36041().method_36077(61, () -> {
			helper.method_35987(composterPos, class_3962.field_17565, 8);
			helper.method_35969(class_1802.field_8741, SPAWN_ITEM_POS, 0);
		}).method_36075();
	}

	private void spawnItemAndExpectNoPickUp(class_4516 helper, class_2338 composterPos, class_1792 item) {
		helper.method_35984(composterPos, class_2246.field_17563);
		spawnItem(helper, item);

		helper.method_36041().method_36077(61, () -> {
			helper.method_35987(composterPos, class_3962.field_17565, 0);
			helper.method_35969(item, SPAWN_ITEM_POS, 0);
		}).method_36075();
	}

	private static void spawnItemFrame(class_4516 helper, class_2338 pos, class_2350 direction, class_1792 item) {
		class_1533 itemFrame = new class_1533(helper.method_35943(), helper.method_36052(pos), direction);
		itemFrame.method_6935(new class_1799(item));
		helper.method_35943().method_8649(itemFrame);
	}

	private class_1542 spawnItem(class_4516 helper, class_1792 item) {
		return helper.method_35968(item, SPAWN_ITEM_X, SPAWN_ITEM_Y, SPAWN_ITEM_Z);
	}

	private static void assertItemInSlot(class_4516 helper, class_2338 furnacePos, int slot, class_1792 expectedItem, int expectedCount) {
		class_1799 stack = getFurnaceBlockEntity(helper, furnacePos).method_5438(slot);
		if (stack.method_7909() != expectedItem) {
			TestingUtil.throwPositionedAssertion(
					helper,
					furnacePos,
					() -> "Expected " + expectedItem + " in slot " + slot + ", but got " + stack.method_7909());
		} else if (stack.method_7947() != expectedCount) {
			TestingUtil.throwPositionedAssertion(
					helper,
					furnacePos,
					() -> "Expected " + expectedCount + " items in slot " + slot + ", but got " + stack.method_7947());
		}
	}

	private static class_2609 getFurnaceBlockEntity(class_4516 helper, class_2338 furnacePos) {
		if (helper.method_36014(furnacePos) instanceof class_2609 furnace) {
			return furnace;
		} else {
			throw new class_4513(
					"Expected furnace here", helper.method_36052(furnacePos), furnacePos, helper.method_36045());
		}
	}
}
